/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.editor.ext;

/**
* Abstract formatting layer offers the support
* for naming the layer and creation
* of an format-support.
*
* @author Miloslav Metelka
* @version 1.00
*/

public abstract class AbstractFormatLayer implements FormatLayer {

    /** Name of the layer */
    private String name;

    /** Construct new layer with the given name. */
    public AbstractFormatLayer(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    /** Create the format-support as an abstraction
     * over the format-writer.
     */
    protected FormatSupport createFormatSupport(FormatWriter fw) {
        return null;
    }

}
