/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.editor;

import java.util.EventObject;

/**
* Event providing information about what was changed in settings
*
* @author Miloslav Metelka
* @version 1.00
*/

public class SettingsChangeEvent extends EventObject {

    private Class kitClass;

    private String settingName;

    private Object oldValue;

    private Object newValue;

    public SettingsChangeEvent(Object source, Class kitClass, String settingName,
                               Object oldValue, Object newValue) {
        super(source);
        this.kitClass = kitClass;
        this.settingName = settingName;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public Class getKitClass() {
        return kitClass;
    }

    public String getSettingName() {
        return settingName;
    }

    public Object getOldValue() {
        return oldValue;
    }

    public Object getNewValue() {
        return newValue;
    }

}
