/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.editor;

import java.awt.Dialog;
import java.util.ResourceBundle;
import javax.swing.*;
import java.awt.event.*;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import javax.swing.text.JTextComponent;
import org.openide.util.NbBundle;


/** The support for creating macros.
 *
 * @author  Petr Nejedly
 * @version 1.0
 */
public class MacroDialogSupport implements ActionListener {

    JButton okButton;
    JButton cancelButton;

    MacroSavePanel panel;
    Dialog macroDialog;
    Class kitClass;
    
    /** Creates new MacroDialogSupport */
    public MacroDialogSupport( Class kitClass ) {
        this.kitClass = kitClass;
        panel = new MacroSavePanel(kitClass);
        ResourceBundle bundle = NbBundle.getBundle(BaseKit.class);
        okButton = new JButton(bundle.getString("MDS_ok")); // NOI18N
        cancelButton = new JButton(bundle.getString("MDS_cancel")); // NOI18N
        okButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_MDS_ok")); // NOI18N
        cancelButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_MDS_cancel")); // NOI18N
    }

    public void setBody( String body ) {
        panel.setBody( body );
    }
    
    public void showMacroDialog() {
        macroDialog = DialogSupport.createDialog(
                NbBundle.getBundle(BaseKit.class).getString("MDS_title"), // NOI18N
                panel, true, new JButton[] { okButton, cancelButton }, false, 0, 1, this );

        macroDialog.pack();
        panel.popupNotify();
        macroDialog.requestFocus();
        macroDialog.show();
    }
    
    private List getKBList(){
        Settings.KitAndValue[] kav = Settings.getValueHierarchy(kitClass, SettingsNames.KEY_BINDING_LIST);
        List kbList = null;
        for (int i = 0; i < kav.length; i++) {
            if (kav[i].kitClass == kitClass) {
                kbList = (List)kav[i].value;
            }
        }
        if (kbList == null) {
            kbList = new ArrayList();
        }
        
        // must convert all members to serializable MultiKeyBinding
        int cnt = kbList.size();
        for (int i = 0; i < cnt; i++) {
            Object o = kbList.get(i);
            if (!(o instanceof MultiKeyBinding) && o != null) {
                JTextComponent.KeyBinding b = (JTextComponent.KeyBinding)o;
                kbList.set(i, new MultiKeyBinding(b.key, b.actionName));
            }
        }
        return new ArrayList( kbList );
    }

    private void saveMacro(boolean overwriting){
        Map macroMap = (Map)Settings.getValue( kitClass, SettingsNames.MACRO_MAP);        
        Map newMap = new HashMap( macroMap );
        newMap.put( panel.getName(), panel.getBody() );                
        Settings.setValue( kitClass, SettingsNames.MACRO_MAP, newMap );
        List listBindings = panel.getKeySequences();

          // insert listBindings into keybindings
        List keybindings = getKBList();
        
        if (overwriting) {
            // overwriting existing macro. Removing all previously attached keybindings.
            List removed = new ArrayList();
            String macroName = BaseKit.macroActionPrefix+panel.getName();
            for (int i=0; i<keybindings.size(); i++){
                MultiKeyBinding multiKey = (MultiKeyBinding)keybindings.get(i);
                if (multiKey.actionName!=null && multiKey.actionName.equals(macroName)){
                    removed.add(multiKey);
                }
            }
            for (int i=0; i<removed.size(); i++){
                keybindings.remove(removed.get(i));
            }
        }
        
        if (listBindings.size() > 0)
        {
            String actionName = new String(BaseKit.macroActionPrefix + panel.getName());
            for (int i = 0; i < listBindings.size(); i++)
            {
                KeyStroke[] keyStrokes = (KeyStroke[])listBindings.get(i);
                MultiKeyBinding multiKey = new MultiKeyBinding(keyStrokes, actionName);
                keybindings.add(multiKey);
            }
        }
        // set new KEY_BINDING_LIST
        Settings.setValue( kitClass, SettingsNames.KEY_BINDING_LIST, keybindings);
    }
    
    protected int showConfirmDialog(String macroName){
        return JOptionPane.showConfirmDialog(panel,                     
                        MessageFormat.format(NbBundle.getBundle(BaseKit.class).getString("MDS_Overwrite"), //NOI18N
                            new Object[] {panel.getName()}), 
                        NbBundle.getBundle(BaseKit.class).getString("MDS_Warning"), // NOI18N
                        JOptionPane.YES_NO_CANCEL_OPTION,
                        JOptionPane.WARNING_MESSAGE);
    }
    
    public void actionPerformed(java.awt.event.ActionEvent evt ) {
        Object source = evt.getSource();
        if( source == okButton ) {
            Map macroMap = (Map)Settings.getValue( kitClass, SettingsNames.MACRO_MAP);
            
            if (!macroMap.containsKey(panel.getName())){
                saveMacro(false);
            }else{
                int retVal = showConfirmDialog(panel.getName());
                if (retVal == JOptionPane.CANCEL_OPTION || retVal == JOptionPane.CLOSED_OPTION) return;
                if (retVal == JOptionPane.OK_OPTION) saveMacro(true);
            }
        }
        macroDialog.setVisible( false );
        macroDialog.dispose();        
    }
    
}
