/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.editor;

import javax.swing.text.Document;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Element;
import javax.swing.text.AttributeSet;
import javax.swing.text.Position;

/**
 * Line element implementation.
 * <BR>The implementation consist of only one backward bias mark.
 * There is a link to next mark to satisfy
 * {@link javax.swing.text.Element#getEndOffset()}.
 * <BR>This way allows to have just three objects
 * (element, element-finalizer, mark) per line of text
 * compared to seven (element, 2 * (position, position-finalizer, mark))
 * in regular leaf element.
 *
 * @author Miloslav Metelka
 * @version 1.00
 */
final class LineElement implements Element, Position {
    
    /** Parent and root element */
    private LineRootElement root;
    
    /** Position at the begining of the line */
    private Position startPos;
    
    /** Next line or null if this is the last line. */
    private Position endPos;
    
    /** Attributes of this line element */
    private AttributeSet attributes;
    
    private Syntax.StateInfo syntaxStateInfo;

    LineElement(LineRootElement root, Position startPos, Position endPos) {
        assert(startPos != null);
        assert(endPos != null);

        this.root = root;
        this.startPos = startPos;
        this.endPos = endPos;
    }

    public Document getDocument() {
        return root.getDocument();
    }

    public int getOffset() {
        return getStartOffset();
    }

    public int getStartOffset() {
        return startPos.getOffset();
    }
    
    Position getStartPosition() {
        return startPos;
    }

    public int getEndOffset() {
        return endPos.getOffset();
    }
    
    Position getEndPosition() {
        return endPos;
    }

    public Element getParentElement() {
        return root;
    }

    public String getName() {
        return AbstractDocument.ParagraphElementName;
    }

    public AttributeSet getAttributes() {
        return attributes;
    }
    
    public void setAttributes(AttributeSet attributes) {
        this.attributes = attributes;
    }

    public int getElementIndex(int offset) {
        return -1;
    }

    public int getElementCount() {
        return 0;
    }

    public Element getElement(int index) {
        return null;
    }

    public boolean isLeaf() {
        return true;
    }
    
    Syntax.StateInfo getSyntaxStateInfo() {
        return syntaxStateInfo;
    }

    void updateSyntaxStateInfo(Syntax syntax) {
        if (syntaxStateInfo == null) {
            syntaxStateInfo = syntax.createStateInfo();
            assert (syntaxStateInfo != null);
        }
        syntax.storeState(syntaxStateInfo);
    }

    void clearSyntaxStateInfo() {
        syntaxStateInfo = null;
    }

    public String toString() {
        return "getStartOffset()=" + getStartOffset() // NOI18N
            + ", getEndOffset()=" + getEndOffset() // NOI18N
            + ", syntaxStateInfo=" + getSyntaxStateInfo(); // NOI18N
    }

}
