/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.editor;

import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.netbeans.api.editor.fold.Fold;

/**
 *  Fake view of the whole document supporting the code folding, operating from given startOffset
 *  to endOffset
 *
 * @author Martin Roskanin
 */
public class DrawEngineFakeDocView extends DrawEngineDocView{
    
        private boolean useCollapsing = true;
        private int fakeStartOffset;
        private int fakeEndOffset;
        
        DrawEngineFakeDocView(Element elem, int startOffset, int endOffset, boolean useCollapsing){
            super(elem);
            
            this.useCollapsing = useCollapsing;
            this.fakeStartOffset = startOffset;
            this.fakeEndOffset = endOffset;
            setEstimatedSpan(false);
            
        }
 
        public int getStartOffset(){
            return fakeStartOffset;
        }
        
        public int getEndOffset(){
            return fakeEndOffset;
        }
        
        protected Fold nextCollapsedFold() {
            return null; // simulate no collapsed folds
        }
        
        protected void attachListeners(){
        }
    
}
