/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.editor;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;

/**
 * Various document-related utilities.
 *
 * @author Miloslav Metelka
 * @version 1.00
 */

public class DocumentUtilities {
    
    static final SegmentCache SEGMENT_CACHE = new SegmentCache();
    
    private DocumentUtilities() {
        // no instances
    }

    /**
     * @return &gt;=0 offset of the gap start in the document's content.
     *         -1 if the document does not export <CODE>GapStart</CODE> interface.
     */
    public static int getGapStart(Document doc) {
        GapStart gs = (GapStart)doc.getProperty(GapStart.class);
        return (gs != null) ? gs.getGapStart() : -1;
    }
    
    /**
     * Copy portion of the document into target character array.
     * @param srcDoc document from which to copy.
     * @param srcStartOffset offset of the first character to copy.
     * @param srcEndOffset offset that follows the last character to copy.
     * @param dst destination character array into which the data will be copied.
     * @param dstOffset offset in the destination array at which the putting
     *  of the characters starts.
     */
    public static void copyText(Document srcDoc, int srcStartOffset,
    int srcEndOffset, char[] dst, int dstOffset) throws BadLocationException {
        Segment text = SEGMENT_CACHE.getSegment();
        try {
            int gapStart = getGapStart(srcDoc);
            if (gapStart != -1 && srcStartOffset < gapStart && gapStart < srcEndOffset) {
                // Get part below gap
                srcDoc.getText(srcStartOffset, gapStart - srcStartOffset, text);
                System.arraycopy(text.array, text.offset, dst, dstOffset, text.count);
                dstOffset += text.count;
                srcStartOffset = gapStart;
            }

            srcDoc.getText(srcStartOffset, srcEndOffset - srcStartOffset, text);
            System.arraycopy(text.array, text.offset, dst, dstOffset, srcEndOffset - srcStartOffset);
            
        } finally {
            SEGMENT_CACHE.releaseSegment(text);
        }
    }

}
