/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.editor.hints.spi;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import javax.swing.text.Document;

/**
 *
 * @author Jan Lahoda
 */
public abstract class HintsProvider {
    
    public static final String PROP_REFRESH = "refresh"; // NOI18N
    
    private PropertyChangeSupport pcs;
    
    /** Creates a new instance of HintsProvider */
    public HintsProvider() {
        pcs = new PropertyChangeSupport(this);
    }
    
    public final void addPropertyChangeListener(PropertyChangeListener l) {
        pcs.addPropertyChangeListener(l);
    }
    
    public final void removePropertyChangeListener(PropertyChangeListener l) {
        pcs.removePropertyChangeListener(l);
    }
    
    protected final void firePropertyChangeEvent(String property, Object old, Object nue) {
        pcs.firePropertyChange(property, old, nue);
    }
    
    public abstract List/*<Hint>*/ getHints(Document doc, int offset);
    
}
