/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.editor.completion;

import java.awt.*;
import javax.swing.*;
import javax.swing.text.JTextComponent;
import javax.swing.text.BadLocationException;


/**
 *
 *  @author Dusan Balek
 */
public class CompletionPopup {
    
    private static final int WINDOW_GAP = 1;

    private JTextComponent component;

    private Popup completionPopup = null;
    private Popup docPopup = null;
    private Popup tipPopup = null;
    
    private JComponent completionComponent = null;
    private int completionOffset = -1;
    private JComponent docComponent = null;
    private int docOffset = -1;
    private JToolTip tipComponent = null;
    private int tipOffset = -1;
    
    private boolean isCompletionAbove = false;
    private boolean isTipAbove = false;

    public void setCompletion(JComponent contents, int offset) {
        if (isCompletionShowing()) {
            completionPopup.hide();
            completionPopup = null;
            completionComponent = null;
            completionOffset = -1;
        }
        if (contents != null) {
            try {
                completionComponent = contents;
                completionOffset = offset;
                Dimension prefSize = completionComponent.getPreferredSize();
                Rectangle rect = component.modelToView(offset < 0 ? component.getCaret().getDot() : offset);
                Point caretPos = rect.getLocation();
                SwingUtilities.convertPointToScreen(caretPos, component);                    
                Rectangle screenBounds = component.getGraphicsConfiguration().getBounds();
                int xDelta = Math.min(0, screenBounds.x + screenBounds.width - caretPos.x - prefSize.width); 
                int yDelta = 0;
                if ((caretPos.y + rect.height + prefSize.height) > (screenBounds.y + screenBounds.height)) {
                    isCompletionAbove = true;                    
                    yDelta = -prefSize.height - WINDOW_GAP;
                } else {
                    isCompletionAbove = false;
                    yDelta = rect.height + WINDOW_GAP;
                }
                caretPos.translate(xDelta, yDelta);
                PopupFactory factory = PopupFactory.getSharedInstance();
                completionPopup = factory.getPopup(null/*component*/, contents, caretPos.x, caretPos.y);
                completionPopup.show();
                if (isTipShowing() && isTipAbove == isCompletionAbove) {
                    setTip(tipComponent, tipOffset);
                }
                if (isDocShowing()) {
                    setDoc(docComponent, docOffset, true);
                }
            } catch (BadLocationException e) {
            }
        }
    }
    
    public boolean isCompletionShowing() {
        return completionPopup != null;
    }

    public void setDoc(JComponent contents, int offset) {
        setDoc(contents, offset, false);
    }
    
    private void setDoc(JComponent contents, int offset, boolean force) {
        if (!force && docComponent == contents && docOffset == offset)
            return;
        if (isDocShowing()) {
            docPopup.hide();
            docPopup = null;
            docComponent = null;
            docOffset = -1;
        }
        if (contents != null) {
            try {
                docComponent = contents;
                docOffset = isCompletionShowing() ? completionOffset : offset < 0 ? component.getCaret().getDot() : offset;
                Dimension prefSize = docComponent.getPreferredSize();
                Rectangle rect = component.modelToView(docOffset);
                Point caretPos = rect.getLocation();
                SwingUtilities.convertPointToScreen(caretPos, component);                    
                Rectangle screenBounds = component.getGraphicsConfiguration().getBounds();
                int xDelta = Math.min(0, screenBounds.x + screenBounds.width - caretPos.x - prefSize.width);
                int yDelta = 0;
                int tipHeight = isTipShowing() ? (int)tipComponent.getHeight() : 0;
                if (isCompletionShowing()) {
                    int completionHeight = (int)completionComponent.getHeight();
                    if (isCompletionAbove) {
                        if ((caretPos.y - prefSize.height - completionHeight) > screenBounds.y) {
                            yDelta = -prefSize.height - completionHeight - WINDOW_GAP;
                        } else {
                            yDelta = rect.height + (isTipShowing() ? tipHeight : 0) + WINDOW_GAP;
                        }
                    } else {
                        if ((caretPos.y + rect.height + completionHeight + prefSize.height) > (screenBounds.y + screenBounds.height)) {
                            yDelta = -prefSize.height - (isTipShowing() ? tipHeight : 0) - WINDOW_GAP;
                        } else {
                            yDelta = rect.height + completionHeight + WINDOW_GAP;
                        }                        
                    }
                } else {
                    if ((caretPos.y - prefSize.height - (isTipAbove ? tipHeight : 0)) > screenBounds.y) {
                        yDelta = -prefSize.height  - (isTipAbove ? tipHeight : 0) - WINDOW_GAP;
                    } else {
                        yDelta = rect.height + (isTipAbove ? tipHeight : 0) + WINDOW_GAP;
                    }                    
                }
                caretPos.translate(xDelta, yDelta);
                PopupFactory factory = PopupFactory.getSharedInstance();
                docPopup = factory.getPopup(null/*component*/, contents, caretPos.x, caretPos.y);
                docPopup.show();
            } catch (BadLocationException e) {
            }
        }
    }

    public boolean isDocShowing() {
        return docPopup != null;
    }

    public void setTip(JToolTip contents, int offset) {
        setTip(contents, offset, false);
    }
    
    private void setTip(JToolTip contents, int offset, boolean force) {
        if (tipComponent == contents && tipOffset == offset)
            return;
        if (isTipShowing()) {
            tipPopup.hide();
            tipPopup = null;
            tipComponent = null;
            tipOffset = -1;
        }
        if (contents != null) {
            try {
                tipComponent = contents;
                tipOffset = offset;
                Dimension prefSize = tipComponent.getPreferredSize();
                Rectangle rect = component.modelToView(offset < 0 ? component.getCaret().getDot() : offset);
                Point caretPos = rect.getLocation();
                SwingUtilities.convertPointToScreen(caretPos, component);                    
                Rectangle screenBounds = component.getGraphicsConfiguration().getBounds();
                int xDelta = Math.min(0, screenBounds.x + screenBounds.width - caretPos.x - prefSize.width);
                int yDelta = 0;
                if (isCompletionShowing() && isCompletionAbove) {
                    isTipAbove = false;
                    yDelta = rect.height + WINDOW_GAP;
                } else {
                    isTipAbove = true;
                    yDelta = -prefSize.height - WINDOW_GAP;
                }
                caretPos.translate(xDelta, yDelta);
                PopupFactory factory = PopupFactory.getSharedInstance();
                tipPopup = factory.getPopup(null/*component*/, contents, caretPos.x, caretPos.y);
                tipPopup.show();
                if (isDocShowing())
                    setDoc(docComponent, docOffset, true);
            } catch (BadLocationException e) {
            }
        }
    }

    public boolean isTipShowing() {
        return tipPopup != null;
    }

    public void setComponent(JTextComponent component) {
        hide();
        this.component = component;
    }

    private void hide() {
        setCompletion(null, -1);
        setDoc(null, -1);
        setTip(null, -1);
    }
}
