/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.diff.builtin.visualizer;

import java.io.*;
import junit.framework.*;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import org.netbeans.modules.diff.builtin.provider.*;
import org.netbeans.modules.diff.builtin.provider.BuiltInDiffProvider;
import org.openide.windows.CloneableOpenSupport;
import org.openide.util.NbBundle;
import org.netbeans.api.diff.Difference;
import org.netbeans.spi.diff.DiffVisualizer;
import org.netbeans.modules.diff.builtin.DiffPresenter;

/**
 *
 * @author Petr Kuzel
 */
public class TextDiffVisualizerTest extends TestCase {
    
    public TextDiffVisualizerTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(TextDiffVisualizerTest.class);
        
        return suite;
    }

    public void testDifferenceToContextDiffText() throws Exception {
        testDifferenceToContextDiffText("WordLibrar");
        testDifferenceToContextDiffText("start-add");
        testDifferenceToContextDiffText("start-ch");
        testDifferenceToContextDiffText("start-rm");
        testDifferenceToContextDiffText("end-add");
        testDifferenceToContextDiffText("end-ch");
        testDifferenceToContextDiffText("end-rm");        
    }

    public void testDifferenceToContextDiffText(String tcase) throws Exception {
        System.out.println("differenceToContextDiffText(" + tcase + ")");
        
        Reader r1 = new InputStreamReader(getClass().getResourceAsStream("data/" + tcase + "0.txt"), "utf8");
        Reader r2 = new InputStreamReader(getClass().getResourceAsStream("data/" + tcase + "1.txt"), "utf8");
        Difference[] diffs = new BuiltInDiffProvider().computeDiff(r1, r2);
        
        r1 = new InputStreamReader(getClass().getResourceAsStream("data/" + tcase + "0.txt"), "utf8");
        r2 = new InputStreamReader(getClass().getResourceAsStream("data/" + tcase + "1.txt"), "utf8");        
        TextDiffVisualizer.TextDiffInfo diffInfo = new TextDiffVisualizer.TextDiffInfo("name1", "name2", "tit1", "tit2", r1, r2, diffs);
        diffInfo.setContextMode(true, 3);
        
        LineNumberReader expResult = new LineNumberReader(new InputStreamReader(getClass().getResourceAsStream("data/" + tcase + ".diff"), "utf8"));
        InputStream result = TextDiffVisualizer.differenceToContextDiffText(diffInfo);
        
        LineNumberReader actResult = new LineNumberReader(new InputStreamReader(result, "utf8"));
        
        // kill headers
        expResult.readLine();
        expResult.readLine();
        
        actResult.readLine();
        actResult.readLine();
                
        while (true) {
            String expLine = expResult.readLine();            
            String actLine = actResult.readLine();            
            if (expLine == null && actLine == null) {
                break;
            }
            System.out.println("" + actLine);
            assertEquals(expLine, actLine);
        }        
    }
    
}
