/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.debugger.jpda.ui.actions;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.netbeans.modules.debugger.jpda.ui.views.ClassesView;

import org.openide.util.NbBundle;
import org.openide.util.Utilities;


/** Opens Breakpoints TopComponent.
 *
 * @author   Peter Zavadsky, Jan Jancura
 */
public class ClassesViewAction extends AbstractAction {

    public ClassesViewAction () {
        putValue (
            Action.NAME, 
            NbBundle.getMessage (
                ClassesViewAction.class, 
                "CTL_ClassesAction"
            )
        );
        putValue (
            Action.SMALL_ICON, 
            new ImageIcon (Utilities.loadImage ("org/netbeans/modules/debugger/resources/classesView/Classes.gif")) // NOI18N
        );
    }

    public void actionPerformed (ActionEvent evt) {
        if (SourcesViewAction.activateComponent (ClassesView.class)) return;
        ClassesView v = new ClassesView ();
        v.open ();
        v.requestActive ();
    }
}

