/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.api.debugger.jpda.test;

import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.api.debugger.Session;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.*;
import java.net.URL;
import java.net.MalformedURLException;
import java.io.File;


/**
 * An engine context suited for automatic test environment. 
 *
 * @author Maros Sandor
 */
public class TestEngineContextProvider extends SourcePathProvider {

    private String          sourceRoot = System.getProperty ("test.dir.src");
    private String[]        originalSourceRoots = new String[] {
                                sourceRoot
                            };
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    
    public TestEngineContextProvider (ContextProvider ctxProvider) {
    //    this.session = (Session) ctxProvider.lookupFirst (null, Session.class);
    }

    /**
     * Translates a relative path (java/lang/Thread.java) to url.
     *
     * @param relativePath a relative path (java/lang/Thread.java)
     * @return url
     */
    public String getURL (String relativePath, boolean global) {
        String url = sourceRoot + relativePath;
        if (new File (url).exists ()) return url;
        return null;
    }


    /**
     * Returns relative path for given url.
     *
     * @param url a url of resource file
     * @param directorySeparator a directory separator character
     * @param includeExtension whether the file extension should be included
     *        in the result
     *
     * @return relative path
     */
    public String getRelativePath (
        String url, 
        char directorySeparator, 
        boolean includeExtension
    ) {
        if (!url.startsWith (sourceRoot)) return null;
        url = url.substring (sourceRoot.length ());
        if (!includeExtension) {
            int i = url.lastIndexOf ('.');
            if (i > 0)
                url = url.substring (0, i);
        }
        url = url.replace ('/', directorySeparator);
        return url;
    }

    /**
     * Returns set of original source roots.
     *
     * @return set of original source roots
     */
    public String[] getOriginalSourceRoots () {
        return originalSourceRoots;
    }

    /**
     * Returns array of source roots.
     *
     * @return array of source roots
     */
    public String[] getSourceRoots () {
        return originalSourceRoots;
    }

    /**
     * Sets array of source roots.
     *
     * @param sourceRoots a new array of sourceRoots
     */
    public void setSourceRoots (String[] sourceRoots) {
    }

    /**
     * Adds property change listener.
     *
     * @param l new listener.
     */
    public void addPropertyChangeListener (PropertyChangeListener l) {
    }

    /**
     * Removes property change listener.
     *
     * @param l removed listener.
     */
    public void removePropertyChangeListener (
        PropertyChangeListener l
    ) {
    }
}
