/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/* Generated By:JJTree: Do not edit this line. SimpleNode.java */

package org.netbeans.modules.debugger.jpda.expr;

import java.util.*;

class SimpleNode implements Node {
  protected Node parent;
  protected Node[] children;
  protected int id;

  public SimpleNode(int i) {
    id = i;
  }

  public void jjtOpen() {
  }

  public void jjtClose() {
  }
  
  public void jjtSetParent(Node n) { parent = n; }
  public Node jjtGetParent() { return parent; }

  public void jjtAddChild(Node n, int i) {
    if (children == null) {
      children = new Node[i + 1];
    } else if (i >= children.length) {
      Node c[] = new Node[i + 1];
      System.arraycopy(children, 0, c, 0, children.length);
      children = c;
    }
    children[i] = n;
  }

  public Node jjtGetChild(int i) {
    return children[i];
  }

  public int jjtGetNumChildren() {
    return (children == null) ? 0 : children.length;
  }

  /** Accept the visitor. **/
  public Object jjtAccept(JavaParserVisitor visitor, Object data) {
    return visitor.visit(this, data);
  }

  /* You can override these two methods in subclasses of SimpleNode to
     customize the way the node appears when the tree is dumped.  If
     your output uses more than one line you should override
     toString(String), otherwise overriding toString() is probably all
     you need to do. */

  public String toString() { return JavaParserTreeConstants.jjtNodeName[id]; }
  public String toString(String prefix) { return prefix + toString(); }

  /* Override this method if you want to customize how the node dumps
     out its children. */

  public void dump(String prefix) {
    System.out.println(toString(prefix));
    if (children != null) {
      for (int i = 0; i < children.length; ++i) {
	SimpleNode n = (SimpleNode)children[i];
	if (n != null) {
	  n.dump(prefix + " ");
	}
      }
    }
  }

    /*
    The following section contains code that was added to this class after it was generated by javacc preprocessor.
    */
    private Map attributes;

    public Object [] getAttributes(String name) {
        if (attributes == null) return null;
        List attrs = getAttributeList(name);
        return attrs.toArray(new Object[attrs.size()]);
    }

    public void addAttribute(String name, Object value) {
        getAttributeList(name).add(value);
    }

    public void setAttribute(String name, Object value) {
        getAttributeMap().put(name, value);
    }

    public Object getAttribute(String name) {
        return (attributes == null) ? null : attributes.get(name);
    }

    private Map getAttributeMap() {
        if (attributes == null) {
            attributes = new HashMap();
        }
        return attributes;
    }

    private List getAttributeList(String name) {
        getAttributeMap();
        List list = (List) attributes.get(name);
        if (list == null) {
            list = new ArrayList();
            attributes.put(name, list);
        }
        return list;
    }

    public int jjtGetID() {
        return id;
    }
}

