/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.test.db.derby.lib;

import org.netbeans.jemmy.operators.*;
import org.netbeans.jemmy.util.NameComponentChooser;

/** Class implementing all necessary methods for handling "Create Java DB Database" NbDialog.
 *
 * @author lg198683
 * @version 1.0
 */
public class CreateDerbyDatabaseOperator extends JDialogOperator {

    /** Creates new CreateDerbyDatabase that can handle it.
     */
    public CreateDerbyDatabaseOperator() {
        super("Create Java DB Database");
    }

    private JTextAreaOperator _txtJTextArea;
    private JLabelOperator _lblDatabaseName;
    private JLabelOperator _lblUserName;
    private JLabelOperator _lblPassword;
    private JLabelOperator _lblDatabaseLocation;
    private JTextFieldOperator _txtPassword;
    private JTextFieldOperator _txtUserName;
    private JTextFieldOperator _txtDatabaseName;
    private JTextFieldOperator _txtDatabaseLocation;
    private JLabelOperator _lblTheDatabaseNameIsEmpty;
    private JButtonOperator _btOK;
    private JButtonOperator _btCancel;


    //******************************
    // Subcomponents definition part
    //******************************

    /** Tries to find null JTextArea in this dialog.
     * @return JTextAreaOperator
     */
    public JTextAreaOperator txtJTextArea() {
        if (_txtJTextArea==null) {
            _txtJTextArea = new JTextAreaOperator(this);
        }
        return _txtJTextArea;
    }

    /** Tries to find "Database Name:" JLabel in this dialog.
     * @return JLabelOperator
     */
    public JLabelOperator lblDatabaseName() {
        if (_lblDatabaseName==null) {
            _lblDatabaseName = new JLabelOperator(this, "Database Name:");
        }
        return _lblDatabaseName;
    }

    /** Tries to find "User Name:" JLabel in this dialog.
     * @return JLabelOperator
     */
    public JLabelOperator lblUserName() {
        if (_lblUserName==null) {
            _lblUserName = new JLabelOperator(this, "User Name:");
        }
        return _lblUserName;
    }

    /** Tries to find "Password:" JLabel in this dialog.
     * @return JLabelOperator
     */
    public JLabelOperator lblPassword() {
        if (_lblPassword==null) {
            _lblPassword = new JLabelOperator(this, "Password:");
        }
        return _lblPassword;
    }

    /** Tries to find "Database Location:" JLabel in this dialog.
     * @return JLabelOperator
     */
    public JLabelOperator lblDatabaseLocation() {
        if (_lblDatabaseLocation==null) {
            _lblDatabaseLocation = new JLabelOperator(this, "Database Location:");
        }
        return _lblDatabaseLocation;
    }

    /** Tries to find null JTextField in this dialog.
     * @return JTextFieldOperator
     */
    public JTextFieldOperator txtPassword() {
        if (_txtPassword==null) {
            _txtPassword = new JTextFieldOperator(this);
        }
        return _txtPassword;
    }

    /** Tries to find null JTextField in this dialog.
     * @return JTextFieldOperator
     */
    public JTextFieldOperator txtUserName() {
        if (_txtUserName==null) {
            _txtUserName = new JTextFieldOperator(this, 1);
        }
        return _txtUserName;
    }

    /** Tries to find null JTextField in this dialog.
     * @return JTextFieldOperator
     */
    public JTextFieldOperator txtDatabaseName() {
        if (_txtDatabaseName==null) {
            _txtDatabaseName = new JTextFieldOperator(this, 2);
        }
        return _txtDatabaseName;
    }

    /** Tries to find null JTextField in this dialog.
     * @return JTextFieldOperator
     */
    public JTextFieldOperator txtDatabaseLocation() {
        if (_txtDatabaseLocation==null) {
            _txtDatabaseLocation = new JTextFieldOperator(this, 3);
        }
        return _txtDatabaseLocation;
    }

    /** Tries to find "The database name is empty." JLabel in this dialog.
     * @return JLabelOperator
     */
    public JLabelOperator lblTheDatabaseNameIsEmpty() {
        if (_lblTheDatabaseNameIsEmpty==null) {
            _lblTheDatabaseNameIsEmpty = new JLabelOperator(this, "The database name is empty.");
        }
        return _lblTheDatabaseNameIsEmpty;
    }

    /** Tries to find "OK" JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btOK() {
        if (_btOK==null) {
            _btOK = new JButtonOperator(this, "OK");
        }
        return _btOK;
    }

    /** Tries to find "Cancel" JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btCancel() {
        if (_btCancel==null) {
            _btCancel = new JButtonOperator(this, "Cancel");
        }
        return _btCancel;
    }


    //****************************************
    // Low-level functionality definition part
    //****************************************

    /** gets text for txtJTextArea
     * @return String text
     */
    public String getJTextArea() {
        return txtJTextArea().getText();
    }

    /** sets text for txtJTextArea
     * @param text String text
     */
    public void setJTextArea(String text) {
        txtJTextArea().setText(text);
    }

    /** types text for txtJTextArea
     * @param text String text
     */
    public void typeJTextArea(String text) {
        txtJTextArea().typeText(text);
    }

    /** gets text for txtPassword
     * @return String text
     */
    public String getPassword() {
        return txtPassword().getText();
    }

    /** sets text for txtPassword
     * @param text String text
     */
    public void setPassword(String text) {
        txtPassword().setText(text);
    }

    /** types text for txtPassword
     * @param text String text
     */
    public void typePassword(String text) {
        txtPassword().typeText(text);
    }

    /** gets text for txtUserName
     * @return String text
     */
    public String getUserName() {
        return txtUserName().getText();
    }

    /** sets text for txtUserName
     * @param text String text
     */
    public void setUserName(String text) {
        txtUserName().setText(text);
    }

    /** types text for txtUserName
     * @param text String text
     */
    public void typeUserName(String text) {
        txtUserName().typeText(text);
    }

    /** gets text for txtDatabaseName
     * @return String text
     */
    public String getDatabaseName() {
        return txtDatabaseName().getText();
    }

    /** sets text for txtDatabaseName
     * @param text String text
     */
    public void setDatabaseName(String text) {
        txtDatabaseName().setText(text);
    }

    /** types text for txtDatabaseName
     * @param text String text
     */
    public void typeDatabaseName(String text) {
        txtDatabaseName().typeText(text);
    }

    /** gets text for txtDatabaseLocation
     * @return String text
     */
    public String getDatabaseLocation() {
        return txtDatabaseLocation().getText();
    }

    /** sets text for txtDatabaseLocation
     * @param text String text
     */
    public void setDatabaseLocation(String text) {
        txtDatabaseLocation().setText(text);
    }

    /** types text for txtDatabaseLocation
     * @param text String text
     */
    public void typeDatabaseLocation(String text) {
        txtDatabaseLocation().typeText(text);
    }

    /** clicks on "OK" JButton
     */
    public void ok() {
        btOK().push();
    }

    /** clicks on "Cancel" JButton
     */
    public void cancel() {
        btCancel().push();
    }


    //*****************************************
    // High-level functionality definition part
    //*****************************************

    /** Performs verification of CreateDerbyDatabase by accessing all its components.
     */
    public void verify() {
        txtJTextArea();
        lblDatabaseName();
        lblUserName();
        lblPassword();
        lblDatabaseLocation();
        txtPassword();
        txtUserName();
        txtDatabaseName();
        txtDatabaseLocation();
        lblTheDatabaseNameIsEmpty();
        btOK();
        btCancel();
    }

    /** Performs simple test of CreateDerbyDatabase
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        new CreateDerbyDatabaseOperator().verify();
        System.out.println("Create Java DB Database verification finished.");
    }
}

