/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.db.api.explorer;

import java.net.URL;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.junit.NbTestCase;
import org.netbeans.modules.db.explorer.DbMetaDataTransferProvider;
import org.openide.filesystems.XMLFileSystem;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderLookup;
import org.openide.util.Lookup;

/**
 *
 * @author Andrei Badea
 */
public class DbMetaDataTransferProviderImplTest extends NbTestCase {

    public DbMetaDataTransferProviderImplTest(String testName) {
        super(testName);
    }

    /**
     * Tests the layer contains is an instance of DbMetaDataTransferProvider in
     * the Services folder and that it works correctly.
     */
    public void testBasic() throws Exception {
        JDBCDriver driver = JDBCDriver.create("foo", "Foo", "org.example.Foo", new URL[0]);
        DatabaseConnection dbconn = DatabaseConnection.create(driver, "url", "user", "schema", "pwd", false);

        XMLFileSystem layerFs = new XMLFileSystem(DbMetaDataTransferProviderImplTest.class.getClassLoader().getResource("org/netbeans/modules/dbapi/resources/layer.xml"));
        DataFolder services = DataFolder.findFolder(layerFs.getRoot().getFileObject("Services"));
        FolderLookup lookup = new FolderLookup(services);

        DbMetaDataTransferProvider dbTransferProvider = (DbMetaDataTransferProvider)lookup.getLookup().lookup(DbMetaDataTransferProvider.class);
        assertNotNull(dbTransferProvider);

        assertSame(DatabaseMetaDataTransfer.TABLE_FLAVOR, dbTransferProvider.getTableDataFlavor());

        DatabaseMetaDataTransfer.Table table = (DatabaseMetaDataTransfer.Table)dbTransferProvider.createTableData(dbconn, driver, "SOME_TABLE");
        assertSame(dbconn, table.getDatabaseConnection());
        assertSame(driver, table.getJDBCDriver());
        assertSame("SOME_TABLE", table.getTableName());
    }
}
