/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.core.windows;


import org.netbeans.core.IDESettings;
import org.openide.util.WeakListeners;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;


/** XXX This class is a bridge to manage consistent value for <code>uiMode</code>
 * property in older core settings <code>IDESettings</code>.
 * If possible, remove the dependency, i.e. provide another way of UI to set the
 * ui mode, not dependent on core module.
 *
 * @author  Peter Zavadsky
 */
final class UIModeHandler implements PropertyChangeListener {

    
    /** Flag to ignore the event changes. Those are caused by our changes. */
    private boolean ignore;
    
    
    /** Creates a new instance of UIModeHandler */
    public UIModeHandler() {
        IDESettings ideSettings = (IDESettings)IDESettings.findObject(IDESettings.class, true);
        ideSettings.addPropertyChangeListener(WeakListeners.propertyChange(this, ideSettings));
    }
    
    
    public void propertyChange(PropertyChangeEvent evt) {
        if(ignore) {
            return;
        }
        
        if(IDESettings.PROP_UIMODE.equals(evt.getPropertyName())) {
            IDESettings ideSettings = (IDESettings)IDESettings.findObject(IDESettings.class, true);
            int uiMode = ideSettings.getUIMode();
            final int editorAreaState;
            // Translate the older values.
            if(uiMode == 1) {
                editorAreaState = Constants.EDITOR_AREA_SEPARATED;
            } else if(uiMode == 2) {
                editorAreaState = Constants.EDITOR_AREA_JOINED;
            } else {
                return;
            }

            javax.swing.SwingUtilities.invokeLater(new Runnable() {
                public void run() {
                    WindowManagerImpl.getInstance().setEditorAreaStateImpl(editorAreaState);
                }
            });
        }
    }
    
    public void setUIMode(int editorAreaState) {
        int uiMode;
        // Translate editorAreaState to uiMode.
        if(editorAreaState == Constants.EDITOR_AREA_JOINED) {
            uiMode = 2;
        } else if(editorAreaState == Constants.EDITOR_AREA_SEPARATED) {
            uiMode = 1;
        } else {
            return;
        }
        
        IDESettings ideSettings = (IDESettings)IDESettings.findObject(IDESettings.class, true);
        try {
            ignore = true;
            ideSettings.setUIMode(uiMode);
        } finally {
            ignore = false;
        }
    }
}

