/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.swing.plaf.aqua;

import java.awt.*;
import java.awt.geom.*;
import java.awt.image.ColorModel;

/**
 * A gradient paint which can do shadows with rounded lower corners.
 *
 * @author Tim Boudreau
 */
public class ShapeGradientPaint implements Paint {
    protected Color shadowColor, mBackgroundColor;
    
    protected Rectangle bounds;
    
    /**
     * Create a shaped gradient paint.  The passed rectangle is the bounds of
     * the object which should have a shadow.  The corner radius is hardcoded
     * in ShapeGradientContext for now.
     */
    public ShapeGradientPaint(Rectangle r, Color pointColor, Color backgroundColor) {
        shadowColor = pointColor;
        mBackgroundColor = backgroundColor;
        this.bounds = r;
    }
    
    private static PaintContext last = null;
    private static AffineTransform lastXform = null;
    private static Rectangle lastBounds = null;
    
    public PaintContext createContext(ColorModel cm,
        Rectangle deviceBounds, Rectangle2D userBounds,
        AffineTransform xform, RenderingHints hints) {
            
        if (last != null && xform.equals(lastXform) && bounds.equals(lastBounds)) {
            return last;
        }
        
        lastBounds = bounds;
        lastXform = xform;
        
        Rectangle r = new Rectangle(bounds);
        Point2D.Double xl = new Point2D.Double (r.x, r.y);
        Point2D.Double rl = new Point2D.Double (r.x + r.width, r.y + r.height);
        
        r.x = (int) xl.x;
        r.y = (int) xl.y;
        r.width = (int) (rl.x - xl.x);
        r.height = (int) (rl.y - xl.y);
        
        last = new ShapeGradientContext (r, shadowColor, mBackgroundColor);
        return last;
    }
    
    public int getTransparency() {
        int a1 = shadowColor.getAlpha();
        int a2 = mBackgroundColor.getAlpha();
        return (((a1 & a2) == 0xff) ? OPAQUE : TRANSLUCENT);
    }
}
