/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.core.startup;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.Lookup;

/** Fake implementation of core bridge for test purposes.
 *
 * @author Jaroslav Tulach
 */
public final class FakeBridge extends CoreBridge {
    /** Attaches or detaches to current category of actions.
     * @param category name or null
     */
    protected void attachToCategory (Object category) {
        
    }
    
    protected void loadDefaultSection (
        ManifestSection ms, 
        org.openide.util.lookup.InstanceContent.Convertor convertor, 
        boolean add
    ) {
        throw new UnsupportedOperationException();
    }
    
    protected void loadActionSection(ManifestSection.ActionSection s, boolean load) throws Exception {
        s.getInstance();
    }
    
    protected void loadLoaderSection(ManifestSection.LoaderSection s, boolean load) throws Exception {
        throw new UnsupportedOperationException();
    }
    
    protected void loaderPoolTransaction (boolean begin) {
        // just ignore
    }

    protected void addToSplashMaxSteps (int cnt) {
        throw new UnsupportedOperationException();
    }
    protected void incrementSplashProgressBar () {
        throw new UnsupportedOperationException();
    }
    
    public Lookup lookupCacheLoad () {
        return Lookup.EMPTY;
    }
    public void lookupCacheStore (Lookup l) throws java.io.IOException {
        throw new UnsupportedOperationException();
    }
    
    public void setStatusText (String status) {
        System.err.println("STATUS: " + status);
    }
    
    public void initializePlaf (Class uiClass, int uiFontSize, java.net.URL themeURL) {
        throw new UnsupportedOperationException();
    }

    public void cliUsage(PrintWriter printWriter) {
    }

    public int cli(String[] string, InputStream inputStream, OutputStream outputStream, File file) {
        return 0;
    }
}
