/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Initial Developer of the Original Software is Laszlo Kishalmi. 
 * Portions Copyright 2004-2004 Laszlo Kishalmi. All Rights Reserved.
 */

package org.netbeans.core.startup.layers;

import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;

/**
 * This URLStreamHandlerFactory registers the patched handling of
 * <code>file</code> and <code>jar</code> protocol.
 * <p>
 * To have detailed information of the patches included see the documentation
 * of the following classes;
 * <ul>
 * <li> {@link org.netbeans.core.jse141urlpatch.FileURLStreamHandler FileURLStreamHandler}
 * <li> {@link org.netbeans.core.jse141urlpatch.JarURLStreamHandler JarURLStreamHandler}
 * </ul>
 * Both problem exist in JRE 1.4.1, but fixed in JRE 1.4.2 and above.
 * @author Laszlo Kishalmi
 * @see java.net.URL
 * @see java.net.URLStreamHandler
 */
public class PatchedURLStreamHandlerFactory implements URLStreamHandlerFactory {
    
    private URLStreamHandler fileHandler = new FileURLStreamHandler();
    private URLStreamHandler jarHandler = new JarURLStreamHandler();
    
    private static PatchedURLStreamHandlerFactory instance = new PatchedURLStreamHandlerFactory();
    
    // Make constructor private as this class is a Singleton.
    private PatchedURLStreamHandlerFactory() {}
    
    /**
     * Returns the patched <code>URLStreamHandler</code> instance in case of the 
     * protocol is <code>file</code> or <code>jar</code>. In other cases it returns 
     * <code>null</code> which implices that JVM will use the default protocol handler 
     * for the given protocol.
     * @param protocol The name of the protocol.
     * @return The patched <code>URLStreamHandler</code> instance in case of the 
     * protocol is <code>file</code> or <code>jar</code>, <code>null</code> otherwise.
     */
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if ("file".equals(protocol)) return fileHandler;
        if ("jar".equals(protocol)) return jarHandler;
        return null;
    }
    
    /**
     * Returns the Singleton instance of <code>PatchedURLStreamHandlerFactory</code> in
     * the current JVM.
     * @return The Singleton instance of <code>PatchedURLStreamHandlerFactory</code> in
     * the current JVM.
     */
    public static PatchedURLStreamHandlerFactory getInstance() {
        return instance;
    }
}
