/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.core.perftool;

/** Class with several utility methods
 *
 */
public final class Util {

    /** flag */
    private static int run = -1;

    /** No instances */
    private Util() {
    }
    
    /** Utility method used to converting milliseconds and
     * bytes to seconds and mega bytes.
     * @param l a number
     * @param radix divider used for conversion from B to MB (1024 * 1024) or from ms to s (1000)
     * @param power number of figures after comma 3->10,283 2->10,28
     */
    public static String long2Print(long l, float radix, int power) {
        double tenpower = tenpower(power);
        double first = ((double) l) / radix;
        long sec = (long) (first * tenpower);
        first = ((double) sec) / tenpower;
        return String.valueOf(first);
    }
    
    /** 0->1, 1->10, 2->100, 3->1000, ... */
    static double tenpower(int power) {
        double ret = 1f;
        double iter = 0f;
        double npower = 10f;
        while (power > 0) {
            iter = (power % 2) * npower;
            if (iter > 0) {
                ret *= iter;
            }
            npower = Math.pow(npower, 2f);
            power /= 2;
        };
        return ret;
    }

    /** @return <tt>true</tt> if this PerformanceMeterImpl is
     * switched on.
     */
    public static boolean isRunning() {
        if (run == -1) {
            String prop = System.getProperty(PerformanceMeter.NAMING_NAME);
            run = (prop == null ? 0 : 1);
        }
        
        return (run == 1);
    }
    
    /** Empty implementation of Runnable */
    private static final class EmptyRunnable implements Runnable {
        EmptyRunnable() {}
        public void run() {
        }
    }
}
