/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.core.perftool;

import java.text.MessageFormat;

import org.openide.ErrorManager;

/** The class collects performance info about different
 * actions in the IDE.
 *
 */
final class PerformanceMeterImpl implements PerformanceMeter {
    
    /** Name of the log for print. */
    static final String LOG_NAME = "IDE-Perf"; // NOI18N
    /** Standard prefix to all messages written into the log. Cf. NbErrorManager. */
    static final String LOG_PREFIX = "[" + LOG_NAME + "] "; // NOI18N
    
    /** Instance */
    private static PerformanceMeterImpl instance;
    /** Log */
    private ErrorManager log;
    
    /** Getter for an instance */
    static PerformanceMeterImpl getInstance() {
        if (instance == null) {
            instance = new PerformanceMeterImpl();
        }
        
        return instance;
    }
    
    /** Constructs new PerformanceMeterImpl */
    private PerformanceMeterImpl() {
    }

    /** Caller notifies PerformanceMeter
     * about a PerformanceEvent
     */
    public void notify(PerformanceEvent ev) {
        if (Util.isRunning()) {
            log(ev.toString());
        }
    }
    
    /** Convenience method  - notifies that an operation took millis milliseconds */
    public void notifyTime(String msg, long millis) {
        if (Util.isRunning()) {
            log(MessageFormat.format("{0} {1} s", new Object[] { msg, Util.long2Print(millis, 1000f, 3) })); // NOI18N
        }
    }
    
    /** Convenience method  - notifies that an operation took "bytes" bytes of heap */
    public void notifyMemory(String msg, long bytes) {
        if (Util.isRunning()) {
            log(MessageFormat.format("{0} {1} MB", new Object[] { msg, Util.long2Print(bytes, 1048576f, 1) })); // NOI18N
        }
    }
    
    /** Getter for the performance log */
    private ErrorManager getLog() {
        if (log == null) {
            log = ErrorManager.getDefault().getInstance(LOG_NAME);
        }
        
        return log;
    }
    
    /** Logs the String */
    private void log(String msg) {
        getLog().log(ErrorManager.USER, msg);
    }
}
