/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.core.perftool;


/** The class collects performance info about different
 * actions in the IDE.
 *
 */
public interface PerformanceMeter {
    
    public static final String NAMING_NAME = "openide.performance.meter"; // NOI18N

    /** Caller notifies PerformanceMeter
     * about a PerformanceEvent
     */
    public void notify(PerformanceEvent ev);

    /** Convenience method  - notifies that an operation took millis milliseconds */
    public void notifyTime(String msg, long millis);
    /** Convenience method  - notifies that an operation took "bytes" bytes of heap */
    public void notifyMemory(String msg, long bytes);
}