/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.core.perftool;

import java.io.File;
import java.io.IOException;
import java.util.*;

/** Extracts data for given tag from given logs
 *
 */
final class Extractor {
    
    /** Constructs new Extractor*/
    private Extractor() {
    }
    
    public static Parser.Field[] extractDateValues(String tag, File[] logs) throws IOException {
        Parser.Field[] fields = extractFields(tag, logs);
        Arrays.sort(fields, new FieldDateComparator());
        return fields;
    }
    
    /**
    public static Parser.Field[] extractMemoryValues(String tag, File[] logs) throws IOException {
        Parser.Field[] fields = extractFields(tag, logs);
        Arrays.sort(fields, new FieldMemoryComparator());
        return fields;
    }*/
    
    public static Parser.Field[] extractTimeValues(String tag, File[] logs) throws IOException {
        Parser.Field[] fields = extractFields(tag, logs);
        Arrays.sort(fields, new FieldTimeComparator());
        return fields;
    }
    
    /** Extract Fields with given name from given logs */
    private static Parser.Field[] extractFields(String tag, File[] logs) throws IOException {
        List fields = new ArrayList(200);
        
        for (int i = 0; i < logs.length; i++) {
            Parser.SessionInfo[] sessions = Parser.getData(logs[i]);
            for (int j = 0; j < sessions.length; j++) {
                Parser.Field field = sessions[j].getField(tag);
                if (field != null) {
                    fields.add(field);
                }
            }
        }
        
        return (Parser.Field[]) fields.toArray(new Parser.Field[fields.size()]);
    }
    
    /** Comparison of two fields is based on the time a measured action took. */
    static final class FieldTimeComparator implements java.util.Comparator {
        public boolean equals(Object o1, Object o2) {
            if (o1 == o2) {
                return true;
            }
            
            Parser.Field flda = (Parser.Field) o1;
            Parser.Field fldb = (Parser.Field) o2;
            
            return (flda.getTime() == fldb.getTime());
        }
        
        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            
            Parser.Field flda = (Parser.Field) o1;
            Parser.Field fldb = (Parser.Field) o2;
            
            if (flda.getTime() == fldb.getTime()) {
                return 0;
            } else if (flda.getTime() > fldb.getTime()) {
                return 1;
            } else {
                return -1;
            }
        }
    }
    
    /** Comparison of two fields is based on the Date a measured action took. */
    static final class FieldDateComparator implements java.util.Comparator {
        public boolean equals(Object o1, Object o2) {
            if (o1 == o2) {
                return true;
            }
            
            Parser.Field flda = (Parser.Field) o1;
            Parser.Field fldb = (Parser.Field) o2;
            
            return (flda.getSessionInfo().getDate().equals(fldb.getSessionInfo().getDate()));
        }
        
        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            
            Parser.Field flda = (Parser.Field) o1;
            Parser.Field fldb = (Parser.Field) o2;
            return flda.getSessionInfo().getDate().compareTo(fldb.getSessionInfo().getDate());
        }
    }
    
    /*
    public static void main(String[] args) throws Exception {
        Parser.Field[] flds;/* = extractTimeValues("Total startup time: ", new File[] { new File("E:\\Gandalf\\system\\ide.log") });
        for (int i = 0; i < flds.length; i++) {
            System.out.println("PROCESSING: " + i);
            System.out.println(flds[i].getSessionInfo().getDescription());
            System.out.println("TIME: " + flds[i].getTime());
        }* /
        flds = extractDateValues("Total startup time: ", new File[] { new File("E:\\Gandalf\\system\\ide.log") });
        for (int i = 0; i < flds.length; i++) {
            System.out.println("PROCESSING: " + i);
            System.out.println(flds[i].getSessionInfo().getDate());
            System.out.println("TIME: " + flds[i].getTime());
        }
    }*/
}