/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.core;

import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;
import java.beans.PropertyEditorSupport;

//import org.netbeans.core.windows.WindowManagerImpl; // TEMP

import org.openide.util.NbBundle;

/** This is a property editor for possible UI modes of the IDE. (SDI. MDI..)
 *
 * @author  Dafe Simonek
 */
public final class UIModePropertyEditor extends PropertyEditorSupport {

    /* <Integer, String> ui mode - display name mappings */
    private Map modes2Names;
    /* <String, Integer> display name - ui mode mappings */
    private Map names2Modes;
    
    public UIModePropertyEditor () {
    }

    /** @return names of the possible UI modes */
    public String[] getTags () {
        return (String[])names2Modes().keySet().toArray(new String[names2Modes.size()]);
    }
    
    public String getAsText () {
        return (String)modes2Names().get(getValue());
    }

    public void setAsText (String text) throws IllegalArgumentException {
        Object value = names2Modes().get(text);
        if (value != null) {
            setValue(value);
        } else {
            throw new IllegalArgumentException();
        }
    }

    /** Safe accessor for names to modes map */
    private Map names2Modes () {
        if (names2Modes == null) {
            names2Modes = new HashMap();
            
            // PENDING move the bundle keys to this package.
            names2Modes.put(
                NbBundle.getMessage(UIModePropertyEditor.class, "CTL_SdiMode"), 
//                new Integer(WindowManagerImpl.UI_MODE_SDI) // TEMP
                new Integer(1) // TEMP
            );
            names2Modes.put(
                NbBundle.getMessage(UIModePropertyEditor.class, "CTL_MdiMode"), 
//                new Integer(WindowManagerImpl.UI_MODE_MDI) // TEMP
                new Integer(2) // TEMP
            );
        }
        return names2Modes;
    }

    /** Safe accessor for modes to names map */
    private Map modes2Names () {
        if (modes2Names == null) {
            Map names2Modes = names2Modes();
            // swap names and mode integer constants
            modes2Names = new HashMap(10);
            Iterator iter = names2Modes.entrySet().iterator();
            Map.Entry curEntry = null;
            while (iter.hasNext()) {
                curEntry = (Map.Entry)iter.next();
                modes2Names.put(curEntry.getValue(), curEntry.getKey());
            }
        }
        return modes2Names;
    }
}
