/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.beaninfo;

import java.awt.Component;
import java.awt.Image;
import java.beans.*;

import org.openide.awt.Actions;
import org.openide.loaders.DataLoader;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.Utilities;

/** BeanInfo for {@link DataLoader}. */
public class DataLoaderBeanInfo extends SimpleBeanInfo {

    public PropertyDescriptor[] getPropertyDescriptors () {
        try {
            PropertyDescriptor representationClass = new PropertyDescriptor ("representationClassName", DataLoader.class, "getRepresentationClassName", null); // NOI18N
            representationClass.setDisplayName (NbBundle.getBundle (DataLoaderBeanInfo.class).getString ("PROP_representationClass"));
            representationClass.setShortDescription (NbBundle.getBundle (DataLoaderBeanInfo.class).getString ("HINT_representationClass"));
            representationClass.setExpert (true);
            PropertyDescriptor actions = new PropertyDescriptor ("actions", DataLoader.class); // NOI18N
            actions.setDisplayName (NbBundle.getBundle (DataLoaderBeanInfo.class).getString ("PROP_actions"));
            actions.setShortDescription (NbBundle.getBundle (DataLoaderBeanInfo.class).getString ("HINT_actions"));
            actions.setPropertyEditorClass (ActionsEditor.class);
            actions.setValue ("canEditAsText", Boolean.FALSE); // NOI18N
            return new PropertyDescriptor[] { actions, representationClass };
        } catch (IntrospectionException ie) {
            org.openide.ErrorManager.getDefault().notify(ie);
            return null;
        }
    }

    /**
    * Return the icon
    */
    public Image getIcon(int type) {
        if ((type == java.beans.BeanInfo.ICON_COLOR_16x16) || (type == java.beans.BeanInfo.ICON_MONO_16x16))
            return Utilities.loadImage("org/netbeans/core/resources/objectTypes.gif"); // NOI18N
        else
            return Utilities.loadImage("org/netbeans/core/resources/objectTypes32.gif"); // NOI18N
    }

    public static class ActionsEditor extends PropertyEditorSupport {

        public boolean supportsCustomEditor () {
            return true;
        }

        public Component getCustomEditor () {
            return new LoaderActionsPanel (this);
        }
        
        public String getAsText () {
            SystemAction[] actions = (SystemAction[]) getValue ();
            if (actions == null) return ""; // NOI18N
            StringBuffer buf = new StringBuffer(actions.length * 15 + 1);
            for (int i = 0; i < actions.length; i++) {
                if (actions[i] == null) continue;
                if (i > 0) buf.append (", "); // I18N?
                buf.append (Actions.cutAmpersand (actions[i].getName ()));
            }
            return buf.toString ();
        }
        
        public void setAsText (String text) throws IllegalArgumentException {
            throw new IllegalArgumentException ();
        }

    }

}
