/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.core.output2.settings;
import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/**
 * @author Milos Kleint
 */

public class OutputSettings extends SystemOption {

    public static final String PROP_WRAP = "wrap"; // NOI18N
    
    private static final long serialVersionUID = -4457782585534382966L;
    
    
    protected void initialize () {
        super.initialize();
        setWrap(false);
    }

    public String displayName () {
        return "output"; //NOI18N - is not shown in UI
    }

    public HelpCtx getHelpCtx () {
        return HelpCtx.DEFAULT_HELP;
    }

    public static OutputSettings getDefault () {
        return (OutputSettings) findObject (OutputSettings.class, true);
    }

    public boolean isWrap() {
        return ((Boolean) getProperty(PROP_WRAP)).booleanValue();
    }

    public void setWrap(boolean wrap) {
        putProperty(PROP_WRAP, Boolean.valueOf(wrap), true);
    }
}
