/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.core.output;

import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/** The action which shows standard IO component.
*
* @author Dafe Simonek
*/
public final class OutputWindowAction extends CallableSystemAction {

    public void performAction() {
        OutputView output = OutputView.findDefault();
        if (!output.isDisplayable()) {
            output = findOutputComponent();
            if (output != null) {
                //OutputView should be defined in XML layer so default
                //code flow is here.
                output.open();
                output.requestActive();
            } else {
                //If OutputView is not defined in XML layer (or is not already present
                //in some mode get instance and dock it to default "output" mode.
                output = OutputView.findDefault();
                if (!output.isShowing()) {
                    Mode mode = WindowManager.getDefault().getCurrentWorkspace().findMode("output"); // NOI18N
                    if (mode == null) {
                        //Mode output not found, create it.
                        String displayName = NbBundle.getBundle(OutputWindowAction.class).getString("CTL_OutputWindow_OutputTab");
                        mode = WindowManager.getDefault().getCurrentWorkspace().createMode("output", displayName, null);
                    }
                    //Dock OutputView to "output" mode.
                    mode.dockInto(output);
                    output.open();
                }
            }
        }
        output.requestActive();
        
        //String name = NbBundle.getBundle(OutputWindowAction.class).getString("CTL_OutputWindow_OutputTab");
        //InputOutput io = output.getIO(name,false);
        //io.select();
    }
    
    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return NbBundle.getBundle(OutputWindowAction.class).getString("OutputWindow");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx (OutputWindowAction.class);
    }

    protected String iconResource () {
        return "org/netbeans/core/resources/frames/output.gif"; // NOI18N
    }
    
    // PENDING When the output will be singleton (new UI spec), remove this method.
    /** Finds last selected component of output family */
    private static OutputView findOutputComponent() {
        Mode mode = WindowManager.getDefault().getCurrentWorkspace().findMode("output"); // NOI18N

        if (mode != null) {
            TopComponent[] tcs = mode.getTopComponents();
            for (int i = 0; i < tcs.length; i++) {
                if (tcs[i] instanceof OutputView) {
                    return (OutputView) tcs[i];
                }
            }
        }
        
        return null;
    }

}
