/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.options.ui;


import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;


/**
 * @author Jan Jancura
 */
public abstract class TableTPModel extends TabbedPanelModel {

    private TableCellRenderer renderer;
    private int layoutOrientation;
    private boolean useScrolls;
    private Map categoryToTableModel = new HashMap ();
    
    
    public TableTPModel (
        boolean useScrolls
    ) {
        this.layoutOrientation = layoutOrientation;
        this.useScrolls = useScrolls;
    }
    
    public JComponent getPanel (String category) {
        JTable t = new JTable (getTableModel (category));
        t.setTableHeader (null);
        if (useScrolls) {
            JScrollPane scrollPane = new JScrollPane (
                t,
                JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
                JScrollPane.HORIZONTAL_SCROLLBAR_NEVER
            );
            scrollPane.setBorder (null);
            return scrollPane;
        }
        t.setBorder (null);
        return t;
    }
    
    public TableModel getTableModel (String category) {
        WeakReference wr = (WeakReference) categoryToTableModel.get 
            (category);
        MyTableModel result = null;
        if (wr != null)
            result = (MyTableModel) wr.get ();
        if (result == null) {
            result = new MyTableModel (category);
            categoryToTableModel.put (category, new WeakReference (result));
        }
        return result;
    }        
    
    public int getRowCount (String category) {
        return 0;
    }       
    
    public int getColumnCount (String category) {
        return 0;
    }
    
    public Object getValueAt (String category, int row, int column) {
        return null;
    }

    public boolean isCellEditable (String category, int row, int column) {
        return false;
    }
    
    public void setValueAt (String category, Object value, int row, int column) {
    }
    
    public void fireTableRowsInserted (
        String category, int firstRow, int lastRow
    ) {
        ((MyTableModel) getTableModel (category)).fireTableRowsInserted 
            (firstRow, lastRow);
    }
     
    public void fireTableRowsDeleted (
        String category, int firstRow, int lastRow
    ) {
        ((MyTableModel) getTableModel (category)).fireTableRowsDeleted 
            (firstRow, lastRow);
    }
    
    
    // innerclasses ............................................................
    
    private class MyTableModel extends AbstractTableModel {
        
        private String category;
        
        private MyTableModel (String category) {
            this.category = category;
        }
        
        public int getRowCount () {
            return TableTPModel.this.getRowCount (category);
        }

        public int getColumnCount () {
            return TableTPModel.this.getColumnCount (category);
        }
        
        public boolean isCellEditable (int row, int col) {
            return TableTPModel.this.isCellEditable (category, row, col);
        }
        
        public void setValueAt (Object value, int row, int column) {
            TableTPModel.this.setValueAt (category, value, row, column);
        }

        public Object getValueAt (int row, int column) {
            return TableTPModel.this.getValueAt (category, row, column);
        }
    };    
}





