/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.options.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;




/**
 */
public class TabbedListPanel extends TabbedPanel {

//    private JList currentList;
    
    public TabbedListPanel (
        ListModel model,
        int expansionPolicy
    ) {
        super (model, expansionPolicy, true);
        addActionListener (new Listener ());
    }
    
    public JList getSelectedList () {
        JComponent c = getSelectedComponent ();
        if (c == null) return null;
        if (c instanceof JList) return (JList) c;
        return (JList) ((JScrollPane) c).getViewport ().getView ();
    }
    
    public int getSelectedListIndex () {
        JList l = getSelectedList ();
        if (l == null) return -1;
        return l.getSelectedIndex ();
    }
    
    public void refreshPanels () {
        super.refreshPanels ();
        
    }    
    
    public void setSelectedListIndex (int index) {
        JList l = getSelectedList ();
        if (l == null) return;
        l.setSelectedIndex (index);
    }
    
    public Object getSelectedListItem () {
        JList l = getSelectedList ();
        if (l == null) return null;
        return l.getSelectedValue ();
    }
    
    private class Listener implements ActionListener, ListSelectionListener {
        
        private JList currentList;
        
        Listener () {
            currentList = getSelectedList ();
            if (currentList != null)
                currentList.addListSelectionListener (this);
        }
        
        public void actionPerformed (ActionEvent e) {
            JList l = getSelectedList ();
            if (l == currentList) return;
            if (currentList != null)
                currentList.removeListSelectionListener (this);
            currentList = l;
            if (currentList != null)
                currentList.addListSelectionListener (this);
        }
        
        public void valueChanged (ListSelectionEvent e) {
            fireActionPerformed (new ActionEvent 
                (TabbedListPanel.this, 0, "selectedIndex")
            );
        }
    }
}





