/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.core.execution;

import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CookieAction;
import org.openide.util.actions.SystemAction;

/**
 * Node representing one process.
 * Can be terminated.
 * @author Ales Novak, Jesse Glick
 */
final class ProcessNodeItem extends AbstractNode {

    /** process that we represents */
    private DefaultSysProcess proc;

    ProcessNodeItem(final DefaultSysProcess proc) {
        super(Children.LEAF);
        setIconBase("org/netbeans/core/resources/process");
        this.proc = proc;
        setName(proc.getName());
        setShortDescription (ProcessNode.getBundle().getString("HINT_ProcessNodeItem"));
        getCookieSet().add(new StopCookie() {
            public void stop() {
                proc.stop();
            }
        });
    }

    public HelpCtx getHelpCtx () {
        return new HelpCtx (ProcessNodeItem.class);
    }

    public SystemAction[] getActions() {
        return new SystemAction[] {
            SystemAction.get(TerminateProcessAction.class),
        };
    }
    
    public boolean canCopy() {
        return false;
    }

    private interface StopCookie extends Node.Cookie {
        void stop();
    }

    /** action that closes the process */
    public static class TerminateProcessAction extends CookieAction {

        protected void performAction(Node[] activatedNodes) {
            for (int i = 0; i < activatedNodes.length; i++) {
                ((StopCookie)activatedNodes[i].getCookie(StopCookie.class)).stop();
            }
        }

        public String getName() {
            return ProcessNode.getBundle().getString("terminateProcess");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx (TerminateProcessAction.class);
        }

        protected String iconResource () {
            return "org/openide/resources/actions/empty.gif"; // NOI18N
        }
        
        protected boolean asynchronous() {
            return false;
        }
        
        protected Class[] cookieClasses() {
            return new Class[] {StopCookie.class};
        }
        
        protected int mode() {
            return MODE_ALL; // #36227 - multi-selects OK
        }
        
    }

}
