/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.beans;


import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.java.ui.nodes.FilterSourceNodeFactory;
import org.netbeans.modules.java.ui.nodes.SourceNodeFactory;
import org.openide.nodes.Node;
import org.openide.nodes.Children;

/** Adds property pattern node to stansdard Java class node

 @author Petr Hrebejk
*/
public final class PatternsExplorerFactory extends FilterSourceNodeFactory {

    private boolean writeable;

    public PatternsExplorerFactory() {
        super();        
    }

    public PatternsExplorerFactory(boolean writable) {
        super();        
        this.writeable = writable;
    }

    public static SourceNodeFactory setWritable(){
        return new PatternsExplorerFactory(true);
    }
    
    public Node createClassNode(JavaClass element) {
        Node node = super.createClassNode(element);

        Children children = node.getChildren();
        
        PatternChildren patternChildren = new PatternChildren(element, writeable);
        
        children.add(new Node[] {
            new PatternGroupNode(patternChildren, writeable)
        });
        return node;
    }

}
