/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.autoupdate;

import java.util.Map;
import org.netbeans.junit.*;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;


/** Tests the module name with any alphabet order.
 * @author Jiri Rechtacek
 * @See issue 53316
 */
public class ModuleNameTest extends AbstractTestHid
        implements org.xml.sax.EntityResolver {
    public ModuleNameTest (String name) {
        super (name);
    }
    
    public static void main (java.lang.String[] args) {
        if (args.length == 1) {
            junit.textui.TestRunner.run (new ModuleNameTest (args[0]));
        } else {
            junit.textui.TestRunner.run (new NbTestSuite (ModuleNameTest.class));
        }
        System.exit (0);
    }
    
    public void testFindModuleByCodenamebase () throws Exception {
        String moduleName = "modules/org-netbeans-modules-aaa.jar";
        String[] jars = new String[] {"modules/dummy.jar", moduleName, "modules/subdir/aaa.jar", "modules/util.jar"};
        testFindModuleByModuleName (moduleName, jars, false, false);
    }
    
    public void testModuleJarControlsAutoload () throws Exception {
        String moduleName = "modules/org-netbeans-modules-aaa.jar";
        String[] jars = new String[] {"modules/autoload/dummy.jar", moduleName, "modules/subdir/aaa.jar", "modules/autoload/util.jar"};
        testFindModuleByModuleName (moduleName, jars, false, false);
        
        // now you are autoload
        jars = new String[] {"modules/autoload/org-netbeans-modules-aaa.jar"};
        testFindModuleByModuleName (moduleName, jars, true, false);
    }
    
    public void testModuleJarControlsEager () throws Exception {
        String moduleName = "modules/org-netbeans-modules-aaa.jar";
        String[] jars = new String[] {"modules/eager/dummy.jar", moduleName, "modules/subdir/aaa.jar", "modules/eager/util.jar"};
        testFindModuleByModuleName (moduleName, jars, false, false);
        
        // now you are eager
        jars = new String[] {"modules/eager/org-netbeans-modules-aaa.jar"};
        testFindModuleByModuleName (moduleName, jars, false, true);
    }
    
    public void testFindModuleByOtherName () throws Exception {
        String moduleName = "modules/dummy.jar";
        String[] jars = new String[] {moduleName};
        testFindModuleByModuleName (moduleName, jars, false, false);
    }
    
    private void testFindModuleByModuleName (String moduleName, String[] jars, boolean autoload, boolean eager) throws Exception {
        File f = generateNbmWithoutModulesXML (jars);
        
        ModuleUpdate mu = ModuleUpdate.getModuleUpdate (f);
        download (mu);
        installNBM (Downloader.getNBM (mu));
        
        Map userFiles = findFiles (userDir);
        for (int i = 0; i < jars.length; i++) {
            assertNotNull ("Contains " + jars[i], userFiles.get (jars[i]));
        }
        
        File config = (File)userFiles.get ("config/Modules/org-netbeans-modules-aaa.xml");
        
        assertNotNull ("The config file was generated", config);

        assertModule ("Should be enabled.", "org-netbeans-modules-aaa", moduleName, true, false, false);
    }
    
    private void assertModule (String txt, String dashBase, String moduleName, boolean enabled, boolean autoload, boolean eager)
    throws Exception {
        boolean f = assertModule (userDir, txt, dashBase, moduleName, enabled, autoload, eager);
        f |= assertModule (platformDir, txt, dashBase, moduleName, enabled, autoload, eager);
        f |= assertModule (clusterDir, txt, dashBase, moduleName, enabled, autoload, eager);
        f |= assertModule (nextDir, txt, dashBase, moduleName, enabled, autoload, eager);
        
        assertTrue ("At least once cluster has to contain the module", f);
    }
    
    private boolean assertModule (File dir, String txt, String dashBase, String moduleName, boolean enabled, boolean autoload, boolean eager)
    throws Exception {
        if (dir == null || !dir.isDirectory ()) {
            return false;
        }
        
        File config = new File (dir, "config/Modules/" + dashBase + ".xml");
        if (!config.isFile ()) {
            return false;
        }
        
        javax.xml.parsers.DocumentBuilderFactory f;
        f = javax.xml.parsers.DocumentBuilderFactory.newInstance ();
        javax.xml.parsers.DocumentBuilder b = f.newDocumentBuilder ();
        b.setEntityResolver (this);
        
        org.w3c.dom.Document document = b.parse (config);
        org.w3c.dom.Element e;
        
        org.w3c.dom.NodeList list = document.getElementsByTagName ("module");
        assertEquals ("One module element", 1, list.getLength ());
        e = (org.w3c.dom.Element)list.item (0);
        assertEquals ("The right name", dashBase.replace ('-', '.'), e.getAttribute ("name"));
        
        boolean jarFound = false;
        list = document.getElementsByTagName ("param");
        for (int i = 0; i < list.getLength (); i++) {
            e = (org.w3c.dom.Element)list.item (i);
            
            String name = e.getAttribute ("name");
            
            boolean toTest;
            if ("autoload".equals (name)) {
                toTest = autoload;
            } else if ("enabled".equals (name)) {
                toTest = enabled;
            } else if ("eager".equals (name)) {
                toTest = eager;
            } else if ("jar".equals (name)) {
                jarFound = true;
                org.w3c.dom.Text t = (org.w3c.dom.Text)e.getChildNodes ().item (0);
                assertNotNull ("Jar file found in config file.", t);
                assertEquals ("The correct jar file.", moduleName, t.getNodeValue ());
                continue;
            } else {
                continue;
            }
            
            org.w3c.dom.Text t = (org.w3c.dom.Text)e.getChildNodes ().item (0);

            assertEquals ("Attribute " + name, toTest, Boolean.valueOf (t.getNodeValue ()).booleanValue ());
        }
        
        assertTrue ("jar attribute must be specified", jarFound);
        return true;
    }
    
    
    private File generateNbmWithoutModulesXML (String[] files) throws Exception {
        String manifest = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" +
                "<!DOCTYPE module PUBLIC \"-//NetBeans//DTD Autoupdate Module Info 2.0//EN\" \"http://www.netbeans.org/dtds/autoupdate-info-2_0.dtd\">" +
                "<module codenamebase=\"org.netbeans.netbeans.aaa\"" +
                "  homepage=\"http://contrib.netbeans.org/\"" +
                "  distribution=\"http://www.netbeans.org/aaa.nbm\"" +
                "  downloadsize=\"0\"" +
                ">" +
                "<manifest " +
                "   OpenIDE-Module=\"org.netbeans.modules.aaa/1\"" +
                "   OpenIDE-Module-Display-Category=\"Infrastructure\"" +
                "   OpenIDE-Module-IDE-Dependencies=\"IDE/1 &gt; 3.17\"" +
                "   OpenIDE-Module-Implementation-Version=\"200404191800\"" +
                "   OpenIDE-Module-Long-Description=\"Testing only.\"" +
                "   OpenIDE-Module-Name=\"Aaa\"" +
                "   OpenIDE-Module-Short-Description=\"Testing only..\"" +
                "   OpenIDE-Module-Specification-Version=\"0.1\"" +
                "/>" +
                "</module>";

        String[] fileList = new String [files.length];
        for (int i = 0; i < files.length; i++) {
            fileList[i] = "netbeans/" + files[i];
        }
        
        File f = generateNBM (fileList, manifest);
        
        return f;
        
    }
    
    public org.xml.sax.InputSource resolveEntity (String publicId, String systemId) throws org.xml.sax.SAXException, IOException {
        java.io.InputStream is = new java.io.ByteArrayInputStream (new byte[0]);
        return new org.xml.sax.InputSource (is);
    }
    
}
