/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.autoupdate;

import java.lang.ref.*;
import java.util.*;

//import junit.framework.*;
import org.netbeans.junit.*;

import java.util.List;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.*;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.*;
import java.util.jar.Manifest;
import java.util.regex.*;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

//import org.openide.ErrorManager;



public class MissingModuleXMLFileGeneratedTest extends AbstractTestHid 
implements org.xml.sax.EntityResolver {
    public MissingModuleXMLFileGeneratedTest (String name) {
        super (name);
    }
    
    public static void main(java.lang.String[] args) {
        if (args.length == 1) {
            junit.textui.TestRunner.run(new MissingModuleXMLFileGeneratedTest (args[0]));
        } else {
            junit.textui.TestRunner.run(new NbTestSuite(MissingModuleXMLFileGeneratedTest.class));
        }
        System.exit (0);
    }    
    
    
    
    public void testNbmWithoutModuleConfigGetsCorrectlyListed () throws Exception {
        File f = generateNbmWithoutModulesXML ("modules/autoload/naming.jar");

        ModuleUpdate mu = ModuleUpdate.getModuleUpdate (f);
        download (mu);
        installNBM (Downloader.getNBM (mu));
        
        
        Map userFiles = findFiles (userDir);
        assertNotNull ("Contains naming.jar", userFiles.get ("modules/autoload/naming.jar"));
        assertNotNull ("Contains update tracking", userFiles.get ("update_tracking/org-netbeans-core-naming.xml"));
        File config = (File)userFiles.get ("config/Modules/org-netbeans-core-naming.xml");
        assertNotNull ("The config file was generated", config);
        
        assertEquals ("Empty platform dir", 0, findFiles (platformDir).size ());
        
        
        assertModule ("Should be autoload", "org-netbeans-core-naming", false, true, false);
    }

    public void testEagerNbmWithoutModuleConfigGetsCorrectlyListed () throws Exception {
        File f = generateNbmWithoutModulesXML ("modules/eager/naming.jar");

        ModuleUpdate mu = ModuleUpdate.getModuleUpdate (f);
        download (mu);
        installNBM (Downloader.getNBM (mu));
        
        
        Map userFiles = findFiles (userDir);
        assertNotNull ("Contains naming.jar", userFiles.get ("modules/eager/naming.jar"));
        assertNotNull ("Contains update tracking", userFiles.get ("update_tracking/org-netbeans-core-naming.xml"));
        File config = (File)userFiles.get ("config/Modules/org-netbeans-core-naming.xml");
        assertNotNull ("The config file was generated", config);
        
        assertEquals ("Empty platform dir", 0, findFiles (platformDir).size ());
        
        
        assertModule ("Should be autoload", "org-netbeans-core-naming", false, false, true);
    }

    public void testRegularNbmWithoutModuleConfigGetsCorrectlyListed () throws Exception {
        File f = generateNbmWithoutModulesXML ("modules/naming.jar");

        ModuleUpdate mu = ModuleUpdate.getModuleUpdate (f);
        download (mu);
        installNBM (Downloader.getNBM (mu));
        
        
        Map userFiles = findFiles (userDir);
        assertNotNull ("Contains naming.jar", userFiles.get ("modules/naming.jar"));
        assertNotNull ("Contains update tracking", userFiles.get ("update_tracking/org-netbeans-core-naming.xml"));
        File config = (File)userFiles.get ("config/Modules/org-netbeans-core-naming.xml");
        assertNotNull ("The config file was generated", config);
        
        assertEquals ("Empty platform dir", 0, findFiles (platformDir).size ());
        
        
        assertModule ("Should be autoload", "org-netbeans-core-naming", true, false, false);
    }
    
    private void assertModule (String txt, String dashBase, boolean enabled, boolean autoload, boolean eager) 
    throws Exception {
        boolean f = assertModule (userDir, txt, dashBase, enabled, autoload, eager);
        f |= assertModule (platformDir, txt, dashBase, enabled, autoload, eager);
        f |= assertModule (clusterDir, txt, dashBase, enabled, autoload, eager);
        f |= assertModule (nextDir, txt, dashBase, enabled, autoload, eager);
        
        assertTrue ("At least once cluster has to contain the module", f);
    }
    
    private boolean assertModule (File dir, String txt, String dashBase, boolean enabled, boolean autoload, boolean eager) 
    throws Exception {
        if (dir == null || !dir.isDirectory ()) {
            return false;
        }
        
        File config = new File (dir, "config/Modules/" + dashBase + ".xml");
        if (!config.isFile ()) {
            return false;
        }

        javax.xml.parsers.DocumentBuilderFactory f;
        f = javax.xml.parsers.DocumentBuilderFactory.newInstance ();
        javax.xml.parsers.DocumentBuilder b = f.newDocumentBuilder ();
        b.setEntityResolver (this);
        
        org.w3c.dom.Document document = b.parse (config);
        org.w3c.dom.Element e;

        org.w3c.dom.NodeList list = document.getElementsByTagName ("module");
        assertEquals ("One module element", 1, list.getLength ());
        e = (org.w3c.dom.Element)list.item (0);
        assertEquals ("The right name", dashBase.replace ('-', '.'), e.getAttribute ("name"));
        
        boolean jarFound = false;
        list = document.getElementsByTagName ("param");
        for (int i = 0; i < list.getLength (); i++) {
            e = (org.w3c.dom.Element)list.item (i);
    
            String name = e.getAttribute ("name");
            
            boolean toTest;
            if ("autoload".equals (name)) {
                toTest = autoload;
            } else if ("enabled".equals (name)) {
                toTest = enabled;
            } else if ("eager".equals (name)) {
                toTest = eager;
            } else if ("jar".equals (name)) {
                jarFound = true;
                continue;
            } else {
                continue;
            }
            
            org.w3c.dom.Text t = (org.w3c.dom.Text)e.getChildNodes ().item (0);
            
            // XXX assertion for debugging on different platforms
            String boolValue = t.getNodeValue ();
            if (!"true".equalsIgnoreCase (boolValue)) {
                if (!"false".equalsIgnoreCase (boolValue)) {
                    fail ("Value of attribute 'name' must be 'true' or 'false' but was: " + boolValue);
                }
            }
            // end of debugging
            
            assertEquals ("Attribute " + name, toTest, Boolean.valueOf (t.getNodeValue ()).booleanValue ());
        }
        
        assertTrue ("jar attribute must be specified", jarFound);
        return true;
    }
    
    
    private File generateNbmWithoutModulesXML (String file) throws Exception {
        String manifest =
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" +
            "<!DOCTYPE module PUBLIC \"-//NetBeans//DTD Autoupdate Module Info 2.0//EN\" \"http://www.netbeans.org/dtds/autoupdate-info-2_0.dtd\">" +
            "<module codenamebase=\"org.netbeans.core.naming\"" + 
            "  homepage=\"http://contrib.netbeans.org/\"" +
            "  distribution=\"http://www.netbeans.org/download/nbms/alpha/dev/naming.nbm\"" +
            "  downloadsize=\"0\"" +
            ">" +
            "<manifest " +
            "   OpenIDE-Module=\"org.netbeans.core.naming/1\"" +
            "   OpenIDE-Module-Display-Category=\"Infrastructure\"" +
            "   OpenIDE-Module-IDE-Dependencies=\"IDE/1 &gt; 3.17\"" +
            "   OpenIDE-Module-Implementation-Version=\"200404191800\"" + 
            "   OpenIDE-Module-Long-Description=\"Provides implementation of JNDI over content of system file system.\"" + 
            "   OpenIDE-Module-Name=\"Naming\"" + 
            "   OpenIDE-Module-Short-Description=\"Implementation of JNDI.\"" + 
            "   OpenIDE-Module-Specification-Version=\"1.4\"" +
            "/>" +
            "</module>";

        String[] fileList = {
            "netbeans/" + file
        };
        
        File f = generateNBM (fileList, manifest);
        
        return f;
        
    }
    
    public org.xml.sax.InputSource resolveEntity (String publicId, String systemId) throws org.xml.sax.SAXException, IOException {
        java.io.InputStream is = new java.io.ByteArrayInputStream (new byte[0]);
        return new org.xml.sax.InputSource (is);
    }
    
}
