/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.autoupdate;

import java.lang.ref.*;
import java.util.*;

//import junit.framework.*;
import org.netbeans.junit.*;

import java.util.List;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.*;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.*;
import java.util.jar.Manifest;
import java.util.regex.*;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.openide.util.NbBundle;

//import org.openide.ErrorManager;



public abstract class AbstractTestHid extends NbTestCase {
    protected File userDir, platformDir, clusterDir, nextDir;
    
    public AbstractTestHid (String name) {
        super (name);
    }
    
    protected void setUp () throws Exception {
        System.setProperty("org.openide.util.Lookup", "-"); 
        
        super.setUp ();
        
        // clear directories first
        this.clearWorkDir();
        
        userDir = new File (getWorkDir(), "user");
        assertTrue (userDir.mkdirs ());
        platformDir = new File (getWorkDir(), "platform");
        assertTrue (platformDir.mkdirs ());
        clusterDir = new File (getWorkDir (), "clstr");
        assertTrue (clusterDir.mkdirs ());
        nextDir = new File (getWorkDir (), "nxtclstr");
        assertTrue (nextDir.mkdirs ());
        
        System.setProperty("netbeans.dirs", "");
        System.setProperty("netbeans.home", platformDir.toString ());
        assertEquals (platformDir.toString (), System.getProperty ("netbeans.home"));
        System.setProperty("netbeans.user", userDir.toString ());
        assertEquals (userDir.toString (), System.getProperty ("netbeans.user"));
    }
    
    protected final void initClusters () {
        System.setProperty(
            "netbeans.dirs", 
            clusterDir.toString() + File.pathSeparatorChar + nextDir
        );
    }
    
    //
    // Utilities
    //
    
    private final File createNewNBMFile () throws IOException {
        int i = 0;
        for (;;) {
            File f = new File (this.getWorkDir(), this.getName() + i++ + ".nbm");
            if (!f.exists ()) return f;
        }
    }
    
    protected final File generateNBM(String[] content, String info) throws IOException {
        File f = createNewNBMFile ();
        
        ZipOutputStream os = new ZipOutputStream (new FileOutputStream (f));
        
        for (int i = 0; i < content.length; i++) {
            os.putNextEntry(new ZipEntry (content[i]));
            os.closeEntry();
        }
        os.putNextEntry (new ZipEntry ("Info/info.xml"));
        os.write (info.getBytes());
        os.closeEntry ();
        os.close();
        
        return f;
    }
    
    protected final File generateNBM(java.util.jar.Manifest[] content, String info) throws IOException {
        File f = createNewNBMFile ();
        
        ZipOutputStream os = new ZipOutputStream (new FileOutputStream (f));
        
        for (int i = 0; i < content.length; i++) {
            ZipEntry entry = new ZipEntry (content[i].getMainAttributes ().getValue ("name"));
            os.putNextEntry(entry);
            java.io.ByteArrayOutputStream array = new java.io.ByteArrayOutputStream ();
            java.util.jar.JarOutputStream jar = new java.util.jar.JarOutputStream (array, content[i]);
            jar.close ();
            os.write (array.toByteArray ());
            os.closeEntry();
        }
        os.putNextEntry (new ZipEntry ("Info/info.xml"));
        os.write (info.getBytes());
        os.closeEntry ();
        os.close();
        
        return f;
    }
    
    protected final static void installNBM (File nbm) {
        installNBMs (new File[] { nbm });
    }
    
    protected final static void installNBMs (File[] nbms) {
        class L implements PropertyChangeListener {
            private PropertyChangeEvent ev;
            public synchronized void propertyChange (PropertyChangeEvent ev) {
                if ("FINISHED".equals (ev.getPropertyName())) {
                    this.ev = ev;
                    notify ();
                }
            }
            
            public PropertyChangeEvent waitForEvent () {
                while (ev == null) {
                    try {
                        wait ();
                    } catch (InterruptedException ex) {
                        fail ("No exceptions expected");
                    }
                }
                return ev;
            }
        }
        
        L listener = new L ();
        synchronized (listener) {
            org.netbeans.updater.UpdaterFrame.runFromIDE(nbms, listener, NbBundle.getBranding ());
            listener.waitForEvent ();
        }
    }
    
    /** Scans files in user dir
     * @return Map<String, File>
     */
    protected final static Map findFiles (File dir) {
        HashMap m = new HashMap ();
        files (m, dir, null);
        return m;
    }
    
    private static void files (HashMap m, File dir, String prefix) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; i++) {
            String name = prefix == null ? files[i].getName () : prefix + "/" + files[i].getName();
            if (files[i].isDirectory()) {
                files (m, files[i], name);
            } else {
                m.put (name, files[i]);
            }
        }
    }
    
    /** Simulates download of the NBM file.
     */
    protected final static void download (ModuleUpdate nbm) throws IOException {
        boolean res = Downloader.downloadFromLocal (nbm);
        JarFile jf = new JarFile (Downloader.getNBM (nbm));
        Enumeration en = jf.entries ();
        while (en.hasMoreElements ()) {
            JarEntry entry = (JarEntry) en.nextElement ();
            SignVerifier.processJarEntry (entry, nbm);
        }
        jf.close ();
        assertTrue ("Download ok for " + nbm.getDistributionFile (), res);
    }
}
