/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package gui.updatecenterwizard.settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

/**
 *
 * @author Jaromir.Uhrik@Sun.Com
 */

public class TestbagsProperties {
    public static final String LOCAL_SERVER_TESTBAG_RESTARTED_PROPERTY_NAME = "LOCAL_SERVER_TESTBAG_RESTARTED";
    public static final String REMOTE_SERVER_TESTBAG_RESTARTED_PROPERTY_NAME = "REMOTE_SERVER_TESTBAG_RESTARTED";
    public static final String NB_SERVER_TESTBAG_RESTARTED_PROPERTY_NAME = "NB_SERVER_TESTBAG_RESTARTED";
    public static final String NBMS_USER_TESTBAG_RESTARTED_PROPERTY_NAME = "NBMS_USER_TESTBAG_RESTARTED";
    public static final String NBMS_GLOBAL_TESTBAG_RESTARTED_PROPERTY_NAME = "NBMS_GLOBAL_TESTBAG_RESTARTED";
    
    File testbagsFile = new File(System.getProperty("xtest.data") + File.separator + "settings" + File.separator + "_testbags.properties");
    
    /** Creates a new instance of TestbagsProperties */
    public TestbagsProperties() {
    }

    public boolean readProperty(String propertyName){
        java.util.Properties p =new java.util.Properties();
        try{
            FileInputStream fis = new FileInputStream(testbagsFile);
            p.load(fis);
            fis.close();
        }catch(Exception e){
            e.printStackTrace();
        }
        return Boolean.valueOf(p.getProperty(propertyName)).booleanValue();
    }
    
    public void writeProperty(String propertyName, boolean value){
        java.util.Properties p =new java.util.Properties();
        try{
            FileInputStream fis = new FileInputStream(testbagsFile);
            p.load(fis);
            p.setProperty(propertyName, Boolean.toString(value));
            fis.close();
            
            FileOutputStream fos = new FileOutputStream(testbagsFile);
            p.store(fos, null);
            fos.close();
            
        }catch(Exception e){
            e.printStackTrace();
        }
    }
    
    
    
}
