/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package gui.updatecenterwizard.settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.*;
import java.text.SimpleDateFormat;
import java.text.ParseException;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.*;

/**
 *
 * @author Jaromir.Uhrik@Sun.Com
 */

public class CatalogXMLFileParser extends DefaultHandler{
    public static final String CATALOG = "catalog";
    public static final String NAME = "name";
    public static final String FILE = "file";
    public static final String PROXY_HOST = "proxy_host";
    public static final String PROXY_PORT = "proxy_port";
    public static final String MODULES = "modules";
    
    CatalogDataValues data;
    StringBuffer buffer;
    
    /** Creates a new instance of StatHandler */
    public CatalogXMLFileParser() throws SAXException{
        data = null;
    }
    
    /**
     * Handles start of the document.
     */
    
    public void startDocument() throws SAXException {
    }
    
    
    /**
     * Handles start of some element.
     */
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        buffer = new StringBuffer();
        
        if (qName.equals(CATALOG)) {
            data = new CatalogDataValues();
        }
    }
    
    /**
     * Handles character data.
     */
    public void characters(char buf[], int offset, int len) throws SAXException {
        buffer.append(buf, offset, len);
    }
    
    /**
     * Handles ends of some elements.
     */
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        
        if (qName.equals(CATALOG)) {
        }
        if (qName.equals(NAME)) {
            if (buffer.length() > 0){
                data.setUcName(buffer.toString());
            }
        }
        if (qName.equals(FILE)) {
            if (buffer.length() > 0){
                data.setUcFile(buffer.toString());
            }
        }
        if (qName.equals(PROXY_HOST)) {
            if (buffer.length() > 0){
                data.setProxyHost(buffer.toString());
            }
        }
        if (qName.equals(PROXY_PORT)) {
            if (buffer.length() > 0){
                data.setProxyPort(buffer.toString());
            }
        }
        if (qName.equals(MODULES)) {
            if (buffer.length() > 0){
                data.setModules(buffer.toString());
            }
        }
    }
    
    public CatalogDataValues getData(){
        return data;
    }
    
}