/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package gui.updatecenterwizard.settings;

import java.util.StringTokenizer;
import java.util.Vector;

/**
 *
 * @author Jaromir.Uhrik@Sun.Com
 */

public class CatalogDataValues {
    
    private String ucName;
    private String ucFile;
    private String proxyHost;
    private String proxyPort;
    private Vector modules;
    
    /** Creates a new instance of DataValues */
    public CatalogDataValues() {
        this("", "", "", "", "");
    }
    
    
    public CatalogDataValues(String ucName, String ucFile, String proxyHost, String proxyPort, String modules) {
        this(ucName, ucFile, proxyHost, proxyPort, modules2Vector(modules));
    }
    
    public CatalogDataValues(String ucName, String ucFile, String proxyHost, String proxyPort, Vector modules) {
        setUcName(ucName);
        setUcFile(ucFile);
        setProxyHost(proxyHost);
        setProxyPort(proxyPort);
        setModules(modules);
    }
    
    public String getUcName() {
        return ucName;
    }
    
    public void setUcName(String ucName) {
        this.ucName = ucName;
    }
    
    public String getUcFile() {
        return ucFile;
    }
    
    public void setUcFile(String ucFile) {
        this.ucFile = ucFile;
    }
    
    public String getProxyHost() {
        return proxyHost;
    }
    
    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }
    
    public String getProxyPort() {
        return proxyPort;
    }
    
    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }
    
    public Vector getModules() {
        return modules;
    }
    
    public void setModules(String modules) {
       setModules(modules2Vector(modules));
    }
    public void setModules(Vector modules) {
        this.modules = modules;
    }
    
    public static Vector modules2Vector(String modules){
        Vector v = new Vector();
        StringTokenizer tokenizer = new StringTokenizer(modules, "|");
        while(tokenizer.hasMoreTokens()){
            v.addElement(tokenizer.nextToken());
        }
        return v;
    }
    public void printValues(){
        System.out.println(ucName);
        System.out.println(ucFile);
        System.out.println(proxyHost);
        System.out.println(proxyPort);
        System.out.println(modules);
        
    }
}
