/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package gui.updatecenterwizard;

import gui.updatecenterwizard.settings.CatalogDataValues;
import gui.updatecenterwizard.settings.CatalogXMLFileParser;
import java.awt.Container;
import java.io.File;
import java.io.FileInputStream;
import javax.swing.JDialog;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.jellytools.WizardOperator;
import org.netbeans.jellytools.actions.Action;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JTableOperator;

/**
 *
 * @author  Lukas.Hasik@Sun.Com, Jaromir.Uhrik@Sun.Com
 */

public class UpdateCenterWizardTests extends JellyTestCase {
    
    public String WORKDIR_PROPERTY="work.dir";
    public String WORKDIR_DEFAULT="C:\\TEMP";
    
    /** Creates a new instance of UpdateCenterWizardTests */
    public UpdateCenterWizardTests(String name) {
        super(name);
        
    }
    
    /* opens Update Center wizard from main menu Tools | Update Center
     */
    public WizardOperator openUpdateCenterWizard() throws JemmyException {
        // "Tools"
        String toolsItem = Bundle.getStringTrimmed("org.netbeans.core.Bundle", "Menu/Tools"); // NOI18N
        WizardOperator updateCenterWizardOper = null;
        String updateCenterItem = Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.Bundle", "CTL_Update");
        new Action(toolsItem+"|"+updateCenterItem, null).perform();
        // "Update Center Wizard"
        String updateCenterTitle = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "CTL_Wizard");
        updateCenterWizardOper = new WizardOperator(updateCenterTitle);
        
        return updateCenterWizardOper;
    }
    
    
    public CatalogDataValues readDataValues(String file){
        CatalogDataValues values = null;
        try{
            CatalogXMLFileParser xfp = new CatalogXMLFileParser();
            javax.xml.parsers.SAXParserFactory saxParserFactory = javax.xml.parsers.SAXParserFactory.newInstance();
            javax.xml.parsers.SAXParser saxParser = saxParserFactory.newSAXParser();
            org.xml.sax.XMLReader parser = saxParser.getXMLReader();
            parser.setContentHandler(xfp);
            //String parsePath = "E:/ide001/autoupdatebuild\test\qa-functional\datasettings\local_settings.xml";
            //parser.parse( new org.xml.sax.InputSource( new FileInputStream(getDataDir() + "settings" + File.separator + file) ));
            parser.parse( new org.xml.sax.InputSource( new FileInputStream(getDataDir() + File.separator + "settings" + File.separator + file) ));
            xfp.getData().printValues();
            values = xfp.getData();
        }catch(Exception e){
            e.printStackTrace();
        }
        return values;
    }
    
    public void setAUtypeSelected(String name, boolean selected){
        WizardOperator ucWizard = openUpdateCenterWizard();
        JTableOperator serversTable=new JTableOperator(ucWizard);
        for(int row = 0; row<serversTable.getRowCount(); row++){
            if(((String)(serversTable.getValueAt(row, 1))).equals(name)){
                serversTable.setValueAt(new Boolean(selected), row, 1);
            }
        }
    }
    public void setAllAUtypesSelected(boolean selected){
        WizardOperator ucWizard = openUpdateCenterWizard();
        JTableOperator serversTable=new JTableOperator(ucWizard);
        for(int row = 0; row<serversTable.getRowCount(); row++){
            serversTable.setValueAt(new Boolean(selected), row, 1);
        }
    }
    public void setAUtypeSelected(int row, boolean selected){
        WizardOperator ucWizard = openUpdateCenterWizard();
        JTableOperator serversTable=new JTableOperator(ucWizard);
        serversTable.setValueAt(new Boolean(selected), row, 1);
    }
    public String getAUtypeName(int row){
        WizardOperator ucWizard = openUpdateCenterWizard();
        JTableOperator serversTable=new JTableOperator(ucWizard);
        String name = (String)(serversTable.getValueAt(row, 1));
        return name;
    }
    /**The function for the test if the AUtype is selected
     *@param row -the UC type index in the table (the first row has index 0)
     */
    public boolean isAUtypeSelected(int row){
        WizardOperator ucWizard = openUpdateCenterWizard();
        JTableOperator serversTable=new JTableOperator(ucWizard);
        Boolean b = (Boolean)(serversTable.getValueAt(row, 0));
        return b.booleanValue();
    }
    
    public void selectAllAsSigned(){
        
        JTableOperator resultsTable = new JTableOperator(openUpdateCenterWizard());
        for(int row=0; row < resultsTable.getRowCount(); row++){
            /*doWait(1000);
            resultsTable.changeSelection(row, col, false, false);*/
            resultsTable.setValueAt(new Boolean(true), row, 0);
            
            /*
            if(((Boolean)resultsTable.getValueAt(row, col)).booleanValue()== false){
                stopper stp = new stopper();
                stp.start();
                JamDialog cert_dialog = new JamDialog("Module Certificate");
                clickButton(cert_dialog, "Always Accept");
            }*/
        }
    }
    public int indexOfButton(String name, JDialogOperator dialog){
        int current_index=0;
        String button_string;
        JButtonOperator button_operator=new JButtonOperator(dialog);
        while(button_operator.findJButton(dialog.getContainer(ComponentSearcher.getTrueChooser("")),ComponentSearcher.getTrueChooser(""),current_index)!=null) {
            button_string = new JButtonOperator(dialog, current_index).toString();
            if(button_string.indexOf(name)!=-1){
                return current_index;
            }
            current_index++;
        }
        return -1;
    }
    public void scloseAllModal() {
        JDialogOperator oper = null;
        // find some JDialog
        JDialog jDialog = JDialogOperator.findJDialog(ComponentSearcher.getTrueChooser(""));
        // number of opened non-modal
        int nonModal = 0;
        // until any modal dialog is opened
        while(jDialog!=null) {
            oper = new JDialogOperator(jDialog);
            if(oper.isModal()) {
                // close if modal
                oper.close();
            } else {
                // increment nonModal
                nonModal++;
            }
            // use nonModal variable as index to skip opened non-modal dialogs
            jDialog = JDialogOperator.findJDialog(ComponentSearcher.getTrueChooser(""), nonModal);
        }
    }
    
    public void confirmAllModal() {
        JDialogOperator oper = null;
        // find some JDialog
        JDialog jDialog = JDialogOperator.findJDialog(ComponentSearcher.getTrueChooser(""));
        // number of opened non-modal
        int nonModal = 0;
        // until any modal dialog is opened
        while(jDialog!=null) {
            oper = new JDialogOperator(jDialog);
            if(oper.isModal()) {
                String unsignedModuleString = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "CTL_NotSignedConfirmation");
                String moduleCertificateString = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "CTL_Certificate_Title");
                
                //press Yes button on "Unsigned Module" dialog
                if(oper.getTitle().indexOf(unsignedModuleString) != -1){
                    new JButtonOperator(oper, "Yes").push();
                }else{
                    //press Accept button on "Module Certificate" dialog
                    if (oper.getTitle().indexOf(moduleCertificateString) != -1){
                        new JButtonOperator(oper, "Accept").push();
                    }else{
                        //other modal dialog just close
                        oper.close();
                    }
                }
                
                
            } else {
                // increment nonModal
                nonModal++;
            }
            // use nonModal variable as index to skip opened non-modal dialogs
            jDialog = JDialogOperator.findJDialog(ComponentSearcher.getTrueChooser(""), nonModal);
        }
    }
    
    public void sleep(int millis){
        try{
            new Thread().sleep(millis);
        }catch(Exception e){
            e.printStackTrace();
        }
    }
}
