/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package gui.updatecenterwizard;

import gui.updatecenterwizard.settings.CatalogDataValues;
import gui.updatecenterwizard.settings.TestbagsProperties;
import java.awt.Component;
import java.io.File;
import java.lang.Thread;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JDialog;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.jellytools.NbDialogOperator;
import org.netbeans.jellytools.OptionsOperator;
import org.netbeans.jellytools.WizardOperator;
import org.netbeans.jellytools.actions.Action;
import org.netbeans.jellytools.actions.ActionNoBlock;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jellytools.properties.Property;
import org.netbeans.jellytools.properties.PropertySheetOperator;
import org.netbeans.jellytools.properties.StringProperty;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.EventTool;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JCheckBoxOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JLabelOperator;
import org.netbeans.jemmy.operators.JTableOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.junit.NbTestSuite;

/**
 *
 * @author Jaromir.Uhrik@Sun.Com
 */

public class R_LocalServerUpdateCenterWizardTests  extends UpdateCenterWizardTests {
    
    CatalogDataValues dataValues = null;
    TestbagsProperties tbp = new TestbagsProperties();
    
    /** Creates a new instance of LocalServerUpdateCenterWizardTests */
    public R_LocalServerUpdateCenterWizardTests(String name) {
        super(name);
    }
    public void setUp() {
        System.out.println("########  "+getName()+"  #######");
        dataValues = readDataValues("R_local_settings.xml");
    }
    
    
    public static NbTestSuite suite() {
        NbTestSuite suite = new NbTestSuite();
        
        suite.addTest(new N_LocalServerUpdateCenterWizardTests("testCreateUpdateCenterType"));
        suite.addTest(new N_LocalServerUpdateCenterWizardTests("testSuccessfulConnection"));
        suite.addTest(new N_LocalServerUpdateCenterWizardTests("testUpdateCenter"));
        suite.addTest(new N_LocalServerUpdateCenterWizardTests("testRestart"));
        return suite;
    }
    
    
    /** Use for execution inside IDE */
    public static void main(java.lang.String[] args) {
        // run whole suite
        //TestRunner.run(suite());
        junit.textui.TestRunner.run(suite());
    }
    
    /** tests creation of new UC type
     * first parses the xml (upon the content sets the UC type attributes)
     * then sets the following:
     * -name
     * -server URL
     */
    public void testCreateUpdateCenterType(){
        //If the updater restarted IDE then do nothing
        if(tbp.readProperty(TestbagsProperties.LOCAL_SERVER_TESTBAG_RESTARTED_PROPERTY_NAME) == true){
            return;
        }
        OptionsOperator optionsOper = OptionsOperator.invoke();
        // set exact comparator because in Japanese there is conflict with Filesystem settings
        optionsOper.treeTable().tree().setComparator(new Operator.DefaultStringComparator(true, true));
        // "IDE Configuration|System|Autoupdate Types"
        String systemSettings = Bundle.getString("org.netbeans.core.Bundle", "UI/Services/IDEConfiguration") + "|" +
                Bundle.getString("org.netbeans.core.Bundle", "UI/Services/IDEConfiguration/System") + "|" +
                Bundle.getString("org.netbeans.modules.updatecenters.resources.Bundle", "Services/AutoupdateType");
        
        Node n = new Node(optionsOper.treeTable().tree(), systemSettings);
        n.select();
        
        new ActionNoBlock(null, /*Bundle.getString("org.openide.loaders.Bundle", "NewTemplate") -doesn't work*/"New" + "|" +
                Bundle.getString("org.netbeans.modules.autoupdate.resources.Bundle", "Templates/Services/AutoupdateType/autoupdate_xml_type.settings")
                ).perform(n);
        
        
        //New Wizard - General Update Center;
        String endTitle = Bundle.getString("org.netbeans.modules.autoupdate.resources.Bundle", "Templates/Services/AutoupdateType/autoupdate_xml_type.settings");
        String startTitle = Bundle.getString("org.openide.loaders.Bundle", "CTL_TemplateTitle2");
        startTitle = startTitle.substring(0, startTitle.length()-3);
        String newWizardTitle = startTitle + endTitle;
        WizardOperator newWizardOperator = null;
        newWizardOperator = new WizardOperator(newWizardTitle);
        
        JTextFieldOperator tfo = new JTextFieldOperator(newWizardOperator, 0);
        tfo.setText(dataValues.getUcName());
        
        newWizardOperator.btFinish().push();
        
        
        String localUCType = systemSettings + "|" + dataValues.getUcName();
        n = new Node(optionsOper.treeTable().tree(), localUCType);
        n.select();
        
        PropertySheetOperator pso = new PropertySheetOperator(optionsOper);
        Property serverURLProperty =  new Property(pso, Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "PROP_Url"));
        serverURLProperty.setValue("file:/" + getDataDir() + File.separator + "catalog" + File.separator + dataValues.getUcFile());
        optionsOper.close();
    }
    
    
    
    /** opens Update Center wizard
     * set proxy to webcache:8080 !!! please change it correctly to your local settings, or comment the line marked with '// !!! proxy !!!'
     * connects to default update center
     */
    public void testSuccessfulConnection() {
        //If the updater restarted IDE then do nothing
        if(tbp.readProperty(TestbagsProperties.LOCAL_SERVER_TESTBAG_RESTARTED_PROPERTY_NAME) == true){
            return;
        }
        
        WizardOperator ucwizard = null;
        try {
            ucwizard = openUpdateCenterWizard();
            
            //only remote UC created by tests will be selected
            setAllAUtypesSelected(false);
            String myUC = dataValues.getUcName();
            setAUtypeSelected(myUC, true);
            
            // set proxy
            // Proxy Configuration...
            String buttonProxyConfLabel = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "BNT_Proxy"); // !!! proxy !!! // NOI18N
            new JButtonOperator(ucwizard, buttonProxyConfLabel).pushNoBlock(); // !!! proxy !!!
            // Proxy Configuration
            String proxyConfDialogTitle = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "CTL_ProxyDialog_Title"); // !!! proxy !!! // NOI18N
            NbDialogOperator proxyDialog = new NbDialogOperator(proxyConfDialogTitle);// !!! proxy !!!
            // Use Proxy check box
            new JCheckBoxOperator(proxyDialog).setSelected(true);// !!! proxy !!!
            // Proxy Host: text field
            new JTextFieldOperator(proxyDialog, 0).setText(dataValues.getProxyHost());// !!! proxy !!! // NOI18N
            // Proxy Port: text field
            new JTextFieldOperator(proxyDialog, 1).setText(dataValues.getProxyPort());// !!! proxy !!! // NOI18N
            proxyDialog.ok();// !!! proxy !!!
            // "Next >"
            ucwizard.btNext().pushNoBlock();
            // wait connecting dialog appears
            // "Connecting"
            String connectingTitle = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "CTL_Connecting_Title");
            // wait at most 60 second until connecting dialog dismiss
            JemmyProperties.setCurrentTimeout("ComponentOperator.WaitStateTimeout", 60000);
            new NbDialogOperator(connectingTitle).waitClosed();
            //check that you are on second pane/step
            String secondStep = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "LAB_221"); //label 'Available Updates and New Modules:' is only on second pane
            new JLabelOperator(ucwizard, secondStep);
            //can close
            ucwizard.close();
            
        } catch (JemmyException e) {
            // close Update center dialog
            if(ucwizard != null) {
                ucwizard.close();
            }
            throw e;
        }
        
    }
    
    /** Test Update Center
     * - open Update Center Wizard from main menu Tools|Update Center
     * - set proxy and go next
     * - wait until connection dialog dismiss
     * - in modules tree select "Development Update Center|Web|Applet" node
     * - click right arrow button and go next
     * - accept license dialog
     * - wait until download is finished and finish the wizard
     */
    public void testUpdateCenter() {
        //If the updater restarted IDE then do nothing
        if(tbp.readProperty(TestbagsProperties.LOCAL_SERVER_TESTBAG_RESTARTED_PROPERTY_NAME) == true){
            return;
        }
        
        // "Tools"
        String toolsItem = Bundle.getStringTrimmed("org.netbeans.core.Bundle", "Menu/Tools"); // NOI18N
        WizardOperator updateCenterWizardOper = null;
        long oldWaitStateTime = JemmyProperties.getCurrentTimeout("ComponentOperator.WaitStateTimeout");
        try {
            // "Update Center"
            String updateCenterItem = Bundle.getStringTrimmed("org.netbeans.modules.autoupdate.Bundle", "CTL_Update");
            new Action(toolsItem+"|"+updateCenterItem, null).perform();
            // "Update Center Wizard"
            String updateCenterTitle = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "CTL_Wizard");
            updateCenterWizardOper = new WizardOperator(updateCenterTitle);
            // disable Forte for Java Update Center if any
            JTableOperator oper = new JTableOperator(updateCenterWizardOper);
            // check each row
            for(int i=0;i<oper.getRowCount();i++) {
                // if Update Center matches "Forte" and it is enabled/checked then click to uncheck
                if(oper.getValueAt(i, 1).toString().indexOf("Forte")>-1 && ((Boolean)oper.getValueAt(i, 0)).booleanValue()) { // NOI18N
                    oper.clickOnCell(i, 0);
                }
                // if Update Center matches "Sun ONE Studio" and it is enabled/checked then click to uncheck
                if(oper.getValueAt(i, 1).toString().indexOf("Sun")>-1 && ((Boolean)oper.getValueAt(i, 0)).booleanValue()) { // NOI18N
                    oper.clickOnCell(i, 0);
                }
            }
            
            // set proxy
            // Proxy Configuration...
            String buttonProxyConfLabel = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "BNT_Proxy"); // NOI18N
            new JButtonOperator(updateCenterWizardOper, buttonProxyConfLabel).pushNoBlock();
            // Proxy Configuration
            String proxyConfDialogTitle = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "CTL_ProxyDialog_Title"); // NOI18N
            NbDialogOperator proxyDialog = new NbDialogOperator(proxyConfDialogTitle);
            // Use Proxy check box
            new JCheckBoxOperator(proxyDialog).setSelected(true);
            // Proxy Host: text field
            new JTextFieldOperator(proxyDialog, 0).setText("webcache"); // NOI18N
            // Proxy Port: text field
            new JTextFieldOperator(proxyDialog, 1).setText("8080"); // NOI18N
            proxyDialog.ok();
            
            // "Next >"
            updateCenterWizardOper.btNext().pushNoBlock();
            // wait connecting dialog appears
            // "Connecting"
            String connectingTitle = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "CTL_Connecting_Title");
            // wait at most 60 second until connecting dialog dismiss
            JemmyProperties.setCurrentTimeout("ComponentOperator.WaitStateTimeout", 60000);
            new NbDialogOperator(connectingTitle).waitClosed();
            // wait JTree generated on next page
            new EventTool().waitNoEvent(500);
            JTreeOperator tree = new JTreeOperator(updateCenterWizardOper);
            // "Development Update Center
            String devUCLabel = Bundle.getString("org.netbeans.modules.updatecenters.resources.Bundle", "Services/AutoupdateType/autoupdate_xml_type.settings");
            
            //add to the right list only modules that are specified in xml file
            for(int i = 0; i<dataValues.getModules().size(); i++){
                new Node(tree, dataValues.getUcName() + "|" + dataValues.getModules().elementAt(i).toString()).select(); // NOI18N
                // add to right panel (push button with tooltip "Add")
                new JButtonOperator(updateCenterWizardOper, new ComponentChooser() {
            /*HINT_Add=Add
             *HINT_AddAll=Add All
             *HINT_Remove=Remove
             *HINT_RemoveAll=Remove All
             */
                    final String addLabel = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "HINT_Add"); // NOI18N
                    public boolean checkComponent(Component comp) {
                        String tooltip = ((JComponent)comp).getToolTipText();
                        if(tooltip != null) {
                            return tooltip.equals(addLabel);
                        } else {
                            return false;
                        }
                    }
                    
                    public String getDescription() {
                        return "JButton with tooltip equals "+addLabel;
                    }
                }).push();
            }
            // push "Next" button
            updateCenterWizardOper.btNext().pushNoBlock();
            // accept license agreement
            // "License Agreement"
            String licenceTitle = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "CTL_Licence_Title");
            // "Accept"
            String acceptLabel = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "CTL_Licence_Accept");
            new JButtonOperator(new NbDialogOperator(licenceTitle), acceptLabel).push();
            // wait 30 s until download is done
            JemmyProperties.setCurrentTimeout("ComponentOperator.WaitComponentTimeout", 30000); // NOI18N
            // "Done."
            String doneLabel = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "DownloadProgressPanel.jLabel1.doneText");
            new JLabelOperator(updateCenterWizardOper, doneLabel);
            updateCenterWizardOper.next();
            // accept certificate if requested
            JTableOperator resultsTable = new JTableOperator(updateCenterWizardOper);
            //select all checkboxes
            for(int row=0; row < resultsTable.getRowCount(); row++){
                //select it only if checkbox is false
                System.out.println(((Boolean)(resultsTable.getValueAt(row, 0))).booleanValue());
                if(((Boolean)(resultsTable.getValueAt(row, 0))).booleanValue()==false){
                    new Thread(){
                        public void run(){
                            try{
                                sleep(1000);
                                confirmAllModal();
                            }catch(Exception e){
                                e.printStackTrace();
                            }
                        }
                    }.start();
                    
                    resultsTable.clickOnCell(row, 0);
                }
            }
        } catch (JemmyException e) {
            // close possible error dialog
            // "Error"
            String errorTitle = Bundle.getString("org.netbeans.modules.autoupdate.Bundle", "CTL_Error");
            if(JDialogOperator.findJDialog(errorTitle, true, true) != null) {
                new NbDialogOperator(errorTitle).close();
            }
            // close Update center dialog
            if(updateCenterWizardOper != null) {
                updateCenterWizardOper.close();
            }
            throw e;
        } finally {
            // restore default timeout
            JemmyProperties.setCurrentTimeout("ComponentOperator.WaitStateTimeout", oldWaitStateTime);
        }
    }
    
    
    public void testRestart(){
        //If the updater restarted IDE then do nothing
        if(tbp.readProperty(TestbagsProperties.LOCAL_SERVER_TESTBAG_RESTARTED_PROPERTY_NAME) == true){
            //if(isRestarted()){
            //This is the last executed line of this suite
            return;
        }
        //Otherwise set atribut that going restarting and restart IDE then
        tbp.writeProperty(TestbagsProperties.LOCAL_SERVER_TESTBAG_RESTARTED_PROPERTY_NAME, true);
        //setRestarted(true);
        WizardOperator updateCenterWizardOper = null;
        updateCenterWizardOper = openUpdateCenterWizard();
        //updateCenterWizardOper.btCancel().push();
        System.out.println("pushing finish...");
        updateCenterWizardOper.btFinish().push();
        // System.out.println("finish pushed...");
    }
    
    
    public boolean isRestarted(){
        return (tbp.readProperty(TestbagsProperties.LOCAL_SERVER_TESTBAG_RESTARTED_PROPERTY_NAME) == true);
    }
    public void setRestarted(boolean value){
        tbp.writeProperty(TestbagsProperties.LOCAL_SERVER_TESTBAG_RESTARTED_PROPERTY_NAME, value);
    }
    
    
 /*   public void testProxyDialogPossibilities() {
  
    }
  
    public void testAddNewAUType() {
  
    }
  
    public void testBadAUUrl() {
  
    }
  
    public void testChangePropagation() {
  
    }
  
    public void testSecondPanelButtons() {
  
    }
  
    public void testAcceptLicence() {
  
    }
  
    public void testSkipDownloadStep() {
  
    }
  
    public void testIncludeCheckBox() {
  
    }
  
    public void testSaveCopy() {
  
    }
  
    public void testSaveCopyWithWrongName() {
  
    }
  
    public void testUninstallAndInstallAUModule() {
  
    }
  */
    
}
