/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.autoupdate;

import java.net.URL;
import java.util.Collection;
import java.util.Date;

import org.w3c.dom.*;

import org.openide.util.*;
import org.openide.modules.ModuleInfo;


/** Serves for building an UpdateCache from XML Document
 * @author  Petr Hrebejk
 */
public abstract class Updates extends Object {

    static final int NO_ERROR = 0;    
    static final int AUTH_ERROR = 2;    
    static final int NO_SERVER_ERROR = 3;
    static final int NO_AVAILABLE_MODULES = 4;
    static final int NO_NETWORK = 5;
    static final int PARSE_ERROR = 6;
    
    /** All installed modules */
    static protected ModuleInfo[] installedModules = null;
    
    /** Stops checking for new updates */
    protected boolean checkCanceled;    
    
    /** Checks for updates in separate thread. Displays progress in a dialog
     */
    public abstract void checkUpdates( final Wizard.Validator validator );

    /** Checks for updates in separate thread. Displays progress in a dialog
     */
    public abstract void checkUpdates( final Wizard.Validator validator, String ucname );
    
    /** Checks for updates in separate thread. Displays progress in a dialog
     */
    public abstract void checkUpdates( final Wizard.Validator validator, AutoupdateType at );
    
    protected void checkUpdates (final Wizard.Validator validator, AutoupdateType at, boolean background) {
        checkUpdates (validator, at);
    }

    public void cancelCheck() {
        checkCanceled = true;
    }

    /** Gets the root of the module/module group tree
     * @return The group in the root of the tree.
     */
    public abstract ModuleGroup getRootGroup();
        
    /** Gets the linear structure of all module updates i.e. Collection
     */
    public abstract Collection getModules();

    /** Gets the state of pError the file was not parsed */
    public abstract boolean isError();
    
    /** Gets the state of pError the file was not parsed */
    public abstract int getError();
    
    /** Gets the server error message if there is any */
    public abstract String getErrorMessage();

    /** Gets array of currently installed modules */
    public static ModuleInfo[] getInstalledModules() {
        if ( installedModules == null )
            installedModules = Autoupdater.Support.getModuleDescriptions();
        return installedModules;
    }
    
    static void reset() {
        installedModules = null;
    }

    /** Gets Collection of patches installed in the system */
    public static ModuleInfo[] getInstalledPatches() {
        return PatchChecker.getPatches();
    }

    /** Returns the time stamp of the downloaded XML file */
    public abstract Date getTimeStamp();

    /** Returns notification text if specified otherwise null */
    public abstract String getNotificationText();

    /** Returns notification URL if specified otherwise null */
    public abstract URL getNotificationURL();
        
}
