/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.autoupdate;

import java.awt.Component;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;

/** This panel is part of Setup Wizard, and is installed dynamically through
 * layers.
 * In aggregation with its UI part, SetupPanel.
 *
 * @author  Ales Kemr
 */
public final class SetupWizardPanel implements WizardDescriptor.FinishablePanel {

    /** aggregation, instance of UI component of this wizard panel */
    private SetupPanel panelUI;

    /** @return AWT component which represents UI of this wizard panel */
    public Component getComponent() {
        return getPanelUI();
    }

    /** @return help context of AU Setup wizard panel */
    public HelpCtx getHelp () {
        return new HelpCtx("setupwizard.autoupdate"); // NOI18N
    }

    /** Initializes UI part from read settings.
    */
    public void readSettings (Object settings) {
        if (settings instanceof WizardDescriptor) {
            getPanelUI().initFromSettings((WizardDescriptor)settings);
        }
    }

    /** Does nothing in this impl.
    */
    public void storeSettings (Object settings) {
    }

    /** Always valid.
     * @return always true.
    */
    public boolean isValid () {
        return true;
    }

    /** Noop, as this wizard panel is always valid.
    * @see #isValid
    */
    public void addChangeListener (ChangeListener l) {
    }

    /** Noop, as this wizard panel is always valid.
    * @see #isValid
    */
    public void removeChangeListener (ChangeListener l) {
    }
    
    /** @return UI component of this wizard panel. Creates new one if
     * accessed for the first time
     */    
    private SetupPanel getPanelUI () {
        if (panelUI == null) {
            panelUI = new SetupPanel();
        }
        return panelUI;
    }

    public boolean isFinishPanel() {
        return true;
    }

}
