/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.autoupdate;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.table.AbstractTableModel;
import javax.swing.JTable;

import java.util.List;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Enumeration;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;
import javax.swing.table.TableModel;

import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

class ServerPanel extends javax.swing.JPanel {

    static final long serialVersionUID =-3335861235683235775L;
    
    /** Creates new ServerPanel */
    public ServerPanel() {
        initComponents();
        
        ServerTableModel model = new ServerTableModel();
        table = new AutoResizeTable(model);
        table.getAccessibleContext().setAccessibleDescription(getBundle("ACS_ServerPanelTable"));
        jLabel1.setLabelFor(table);
        table.getColumnModel().getColumn(0).setMaxWidth(36);         

        jScrollPane1.setViewportView(table);
        model.refreshContent();                

        jLabel1.setDisplayedMnemonic(getBundle("LAB_AvailableServers_Mnemonic").charAt(0));

        getAccessibleContext().setAccessibleDescription(getBundle("ACS_ServerPanel"));
    }
    
    static class AutoResizeTable extends JTable {
            private boolean firstPaint = true;
            private int hm = 1;
            public AutoResizeTable (TableModel model) {
                super (model);
            }
            public AutoResizeTable (TableModel model, int heightMultiple) {
                this(model);
                this.hm = heightMultiple;
            }
            public void paint (Graphics g) {
                if (firstPaint) {
                    adjustRowHeight(g);
                    firstPaint = false;
                    //it will trigger another paint anyway
                    return;
                }
                super.paint(g);
            }
        private void adjustRowHeight(Graphics g) {
            Font f = getFont();
            FontMetrics fm = g.getFontMetrics(f);
            int rowHeight = hm * fm.getHeight();
            // #55754: Cell height too small for checkbox
            setRowHeight (hm == 1 ? rowHeight + 4: rowHeight);
        }
    }
            
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jScrollPane1 = new javax.swing.JScrollPane();
        jLabel1 = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.RELATIVE;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jScrollPane1, gridBagConstraints);

        jLabel1.setText(getBundle("LAB_AvailableServers"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(jLabel1, gridBagConstraints);

    }//GEN-END:initComponents
              
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables
    private javax.swing.ButtonGroup buttonGroup;
    private JTable table;

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        table.setEnabled(enabled);
    }
    
    private static String getBundle( String key ) {
        return NbBundle.getMessage( ServerPanel.class, key );
    }
    
    class ServerTableModel extends AbstractTableModel {
        final String[] columnNames = {" ", 
                                      getBundle("LAB_TableHeader")};
        private List atypes = new ArrayList();

        private PropertyChangeListener listener = new PropertyChangeListener() {
                          public void propertyChange(PropertyChangeEvent event) {                              
                              if (event.getPropertyName().equals(AutoupdateType.PROP_ENABLED)) {
                                  table.repaint();
                              }
                          }
                      };

        public int getColumnCount() {
            return columnNames.length;
        }
        
        public int getRowCount() {
            return atypes.size();
        }

        public String getColumnName(int col) {
            return columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            if (col == 0)
                return ((AutoupdateType)atypes.get(row)).isEnabled() ? Boolean.TRUE : Boolean.FALSE;
            else
                return ((AutoupdateType)atypes.get(row)).getName();
        }

        public Class getColumnClass(int c) {
            return getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            if (col > 0) { 
                return false;
            } else {
                return true;
            }
        }

        public void setValueAt(Object value, int row, int col) {
            if (value instanceof Boolean)
                ((AutoupdateType)atypes.get(row)).setEnabled(((Boolean)value).booleanValue());
        }
        
        void refreshContent() {
            HashMap allUpdates = new HashMap();
            Enumeration en = AutoupdateType.autoupdateTypes();
            atypes.clear();
            while (en.hasMoreElements()) {
                AutoupdateType at = (AutoupdateType)en.nextElement();
                atypes.add(at);
                at.addPropertyChangeListener( WeakListeners.propertyChange(listener,at) );
            }
        }
    }
}
