/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.autoupdate;


import java.awt.Component;
import java.awt.Font;
import java.util.*;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

import javax.swing.JList;

import org.openide.util.NbBundle;

/** Paints the list items in the ResultsListBox
 * @author  phrebejk
 * @version 
 */
class ResultListCellRenderer extends javax.swing.JPanel
    implements javax.swing.ListCellRenderer{

    static final long serialVersionUID =-3181200208271061471L;

    private static final String SPACE = " "; //NOI18N

    private static final String BAD_DOWNLOAD = SPACE + getBundle("CTL_BAD_DOWNLOAD") + SPACE;
    private static final String CORRUPTED = SPACE + getBundle("CTL_CORRUPTED") + SPACE;
    private static final String NOT_SIGNED = SPACE + getBundle("CTL_NOT_SIGNED") + SPACE;
    private static final String SIGNED = SPACE + getBundle("CTL_SIGNED") + SPACE;
    private static final String TRUSTED = SPACE + getBundle("CTL_TRUSTED") + SPACE;

    /** The one instalnce of the renderer in the system */
    private static ResultListCellRenderer renderer = null;


    public Component getListCellRendererComponent( JList list,
            Object value,
            int index,
            boolean isSelected,
            boolean cellHasFocus) {
        if ( renderer == null ) {
            renderer = new ResultListCellRenderer();
        }
        
        renderer.includeCheckBox.setSelected(((ModuleUpdate)value).isInstallApproved());
        renderer.globalCheckBox.setSelected(((ModuleUpdate)value).isToInstallDir());
        
        String sec = ""; // NOI18N
        switch ( ((ModuleUpdate)value).getSecurity() ) {
        case SignVerifier.BAD_DOWNLOAD:
            sec = BAD_DOWNLOAD;
            break;
        case SignVerifier.CORRUPTED:
            sec = CORRUPTED;
            break;
        case SignVerifier.NOT_SIGNED:
            sec = NOT_SIGNED;
            break;
        case SignVerifier.SIGNED:
            StringBuffer sb = new StringBuffer( SIGNED );
            sb.append( SPACE + getBundle("CTL_By"));
            Collection certs = ((ModuleUpdate)value).getCerts();
            Iterator it = certs.iterator();
            while ( it.hasNext() ) {
                Certificate cert = (Certificate)it.next();
                if ( cert instanceof X509Certificate ) {
                    sb.append( " " ).append( ((X509Certificate)cert).getSubjectDN().getName() ); //NOI18N
                }
            }

            sec = sb.toString();
            break;
        case SignVerifier.TRUSTED:
            sec = TRUSTED;
            break;
        }

        renderer.nameLabel.setText( ((ModuleUpdate)value).getName() +
                                    "  " + getBundle( "CTL_Version" ) +
                                    ((ModuleUpdate)value).getRemoteModule().getSpecificationVersion());
        renderer.securityLabel.setText( sec );

        renderer.includeCheckBox.getAccessibleContext().setAccessibleDescription(renderer.nameLabel.getText());
        renderer.includeCheckBox.setMnemonic(getBundle("ACS_Include_Mnem").charAt(0));
        renderer.globalCheckBox.getAccessibleContext().setAccessibleDescription(getBundle("ACS_Global1")+renderer.nameLabel.getText() + getBundle("ACS_Global2"));
        renderer.globalCheckBox.setMnemonic(getBundle("ACS_Global_Mnem").charAt(0));

        if ( isSelected ) {
            renderer.setBackground ((java.awt.Color) javax.swing.UIManager.getDefaults ().get ("List.selectionBackground")); // NOI18N
            renderer.nameLabel.setForeground((java.awt.Color) javax.swing.UIManager.getDefaults ().get ("List.selectionForeground")); // NOI18N
            renderer.securityLabel.setForeground((java.awt.Color) javax.swing.UIManager.getDefaults ().get ("List.selectionForeground")); // NOI18N
            renderer.includeCheckBox.setBackground((java.awt.Color) javax.swing.UIManager.getDefaults ().get ("List.selectionBackground")); // NOI18N
            renderer.includeCheckBox.setForeground((java.awt.Color) javax.swing.UIManager.getDefaults ().get ("List.selectionForeground")); // NOI18N
            renderer.globalCheckBox.setBackground((java.awt.Color) javax.swing.UIManager.getDefaults ().get ("List.selectionBackground")); // NOI18N
            renderer.globalCheckBox.setForeground((java.awt.Color) javax.swing.UIManager.getDefaults ().get ("List.selectionForeground")); // NOI18N
        }
        else {
            renderer.setBackground ((java.awt.Color) javax.swing.UIManager.getDefaults ().get ("List.background")); // NOI18N
            renderer.nameLabel.setForeground((java.awt.Color) javax.swing.UIManager.getDefaults ().get ("List.Foreground")); // NOI18N
            renderer.securityLabel.setForeground((java.awt.Color) javax.swing.UIManager.getDefaults ().get ("List.Foreground")); // NOI18N
            renderer.includeCheckBox.setBackground((java.awt.Color) javax.swing.UIManager.getDefaults ().get ("List.background")); // NOI18N
            renderer.includeCheckBox.setForeground((java.awt.Color) javax.swing.UIManager.getDefaults ().get ("List.Foreground")); // NOI18N
            renderer.globalCheckBox.setBackground((java.awt.Color) javax.swing.UIManager.getDefaults ().get ("List.background")); // NOI18N
            renderer.globalCheckBox.setForeground((java.awt.Color) javax.swing.UIManager.getDefaults ().get ("List.Foreground")); // NOI18N
        }

        renderer.invalidate();

        return renderer;

    }


    /** Creates new form ResultListCellRenderer */
    public ResultListCellRenderer() {
        initComponents ();
        // don't use deriveFont() - see #49973 for details
        nameLabel.setFont(ResultsPanel.doDeriveFont(nameLabel.getFont(), Font.BOLD));
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        includeCheckBox = new javax.swing.JCheckBox();
        nameLabel = new javax.swing.JLabel();
        securityLabel = new javax.swing.JLabel();
        globalCheckBox = new javax.swing.JCheckBox();

        setLayout(new java.awt.GridBagLayout());

        setBackground(java.awt.Color.white);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        add(includeCheckBox, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.RELATIVE;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        add(nameLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.RELATIVE;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        add(securityLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        add(globalCheckBox, gridBagConstraints);

    }//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox globalCheckBox;
    private javax.swing.JCheckBox includeCheckBox;
    private javax.swing.JLabel nameLabel;
    private javax.swing.JLabel securityLabel;
    // End of variables declaration//GEN-END:variables

    boolean isIncludeCheckBoxSelected(java.awt.event.MouseEvent evt) {
        return (((includeCheckBox.getX()+includeCheckBox.getWidth()) >= evt.getX()) &&
            (includeCheckBox.getX() <= evt.getX()));
    }
    
    boolean isGlobalCheckBoxSelected(java.awt.event.MouseEvent evt) {
        return (((globalCheckBox.getX()+globalCheckBox.getWidth()) >= evt.getX()) &&
            (globalCheckBox.getX() <= evt.getX()));
    }
    
    private static String getBundle( String key ) {
        return NbBundle.getMessage( ResultListCellRenderer.class, key );
    }
}