/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.autoupdate;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openide.awt.StatusLineElementProvider;
import org.openide.util.Utilities;

/**
 *
 * @author  Jiri Rechtacek
 */
public final class ProblemsVisualizerProvider implements StatusLineElementProvider {

    public Component getStatusLineElement () {
        return getProblemsVisualizer ();
    }

    private static UpdatesFlasher flasher = null;
    
    private static Runnable onMouseClick = null;

    /**
     * Return an icon that is flashing when a new internal exception occurs. 
     * Clicking the icon opens the regular exception dialog box. The icon
     * disappears (is hidden) after a short period of time and the exception
     * list is cleared.
     *
     * @return A flashing icon component or null if console logging is switched on.
     */
    private static Component getProblemsVisualizer () {
        if (null == flasher) {
            ImageIcon img1 = new ImageIcon (Utilities.loadImage ("org/netbeans/modules/autoupdate/resources/problems.gif", false));
            assert img1 != null : "Icon cannot be null.";
            flasher = new UpdatesFlasher (img1);
        }
        return flasher;
    }
    
    static UpdatesFlasher getFlasher (Runnable whatRunOnMouseClick) {
        onMouseClick = whatRunOnMouseClick;
        return flasher;
    }
    
    static class UpdatesFlasher extends FlashingIcon {
        public UpdatesFlasher (Icon img1) {
            super (img1);
            STOP_FLASHING_DELAY = 0;
            DISAPPEAR_DELAY_MILLIS = -1;
            FLASHING_FREQUENCY = 250;
        }

        /**
         * User clicked the flashing icon, display the exception window.
         */
        protected void onMouseClick () {
            if (onMouseClick != null) {
                onMouseClick.run ();
                disappear ();
            }
        }
        
        /**
         * The flashing icon disappeared (timed-out), clear the current
         * exception list.
         */
        protected void timeout () {}
    }
    
}
