/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.autoupdate;

import java.io.IOException;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.UniFileLoader;
import org.openide.util.NbBundle;

/** Recognizes single files in the Repository as being of a certain type.
 *
 * @author Ales Kemr
 */
public final class NbmDataLoader extends UniFileLoader {

    /** SUID */
    static final long serialVersionUID=-3599951493531214988L;
    
    public NbmDataLoader () {
        this ("org.netbeans.modules.autoupdate.NbmDataObject"); // NOI18N
    }

    public NbmDataLoader (String repClass) {
        super (repClass);
    }
    
    public NbmDataLoader (Class recognizedObject) {
        super (recognizedObject);
    }

    protected void initialize () {

        super.initialize ();        

        ExtensionList extensions = new ExtensionList ();
        extensions.addExtension ("nbm");                 // NOI18N
        setExtensions (extensions);        
    }
    
    protected String actionsContext () {
        return "Loaders/application/x-nbm/Actions/"; // NOI18N
    }
    
    /** Get the default display name of this loader.
    * @return default display name
    */
    protected String defaultDisplayName () {
        return NbBundle.getMessage (NbmDataLoader.class, "LBL_loaderName");
    }
    
    protected MultiDataObject createMultiObject (FileObject primaryFile)
    throws DataObjectExistsException, IOException {
        return new NbmDataObject (primaryFile, this);
    }

}
