/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.autoupdate;

import java.beans.Customizer;
import org.openide.util.NbBundle;

class LoginPanel extends javax.swing.JPanel {

    Wizard.Validator validator;

    Settings settings = null;
    
    static final long serialVersionUID =-3335860872113235775L;

    /** customizer panel */
    private javax.swing.JPanel customizer = null;
    
    private java.awt.GridBagConstraints gridBagConstraints1 = new java.awt.GridBagConstraints();

    /** Creates new form FirstPanel */
    public LoginPanel(Wizard.Validator validator) {
        putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);   // NOI18N
        putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);  // NOI18N
        putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);   // NOI18N
        putClientProperty("WizardPanel_contentSelectedIndex", new Integer(0)); // NOI18N
        putClientProperty("WizardPanel_contentData", new String[] {            // NOI18N
            getBundle("WIZ_First"),            
            getBundle("WIZ_Select"),
            getBundle("WIZ_Download"),
            getBundle("WIZ_View")
        });
        setName(getBundle("LAB_Login"));
        initComponents ();
        initAccessibility();
        setPreferredSize(new java.awt.Dimension(500, 380));        
        
        settings = Settings.getShared();

        this.validator = validator;                
        
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.NORTHWEST;        
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
    }   
    
    void setCustomizer(javax.swing.JPanel panel, AutoupdateType at) {        
        setName(getBundle("LAB_Login") + " - " + at.getName());
        
        if (customizer != null)
            this.remove(customizer);
        customizer = panel;        
        if (customizer != null) {
            ((Customizer)customizer).setObject(at);
            this.add(customizer, gridBagConstraints1);
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents

        setLayout(new java.awt.GridBagLayout());

    }//GEN-END:initComponents
              
    private void initAccessibility(){
        getAccessibleContext().setAccessibleDescription(getBundle("ACSD_LoginPanel"));
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables

    private static String getBundle( String key ) {
        return NbBundle.getMessage( LoginPanel.class, key );
    }
}
