/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.autoupdate;

import javax.swing.table.AbstractTableModel;

import java.util.List;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Enumeration;

import org.openide.util.NbBundle;

class FirstPanel extends javax.swing.JPanel {

    Wizard.Validator validator;

    static final long serialVersionUID =-3335860872113235775L;
    
    /** Creates new form FirstPanel */
    public FirstPanel( Wizard.Validator validator ) {
        putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);   // NOI18N
        putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);  // NOI18N
        putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);   // NOI18N
        putClientProperty("WizardPanel_contentSelectedIndex", new Integer(0)); // NOI18N
        putClientProperty("WizardPanel_contentData", new String[] {            // NOI18N
            getBundle("WIZ_First"),
            getBundle("WIZ_Select"),
            getBundle("WIZ_Download"),
            getBundle("WIZ_View")
        });
        setName(getBundle("LAB_First"));
        initComponents ();
//        setPreferredSize(new java.awt.Dimension(500, 380));        
        
        this.validator = validator;
        
        jPanel1 = new ServerPanel();
        java.awt.GridBagConstraints gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.gridheight = 5;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.insets = new java.awt.Insets(12, 36, 0, 36);
        gridBagConstraints1.weighty = 1.0;
        add(jPanel1, gridBagConstraints1);                

        getAccessibleContext().setAccessibleDescription(getBundle("ACS_FirstPanel"));
        jRadioButton1.getAccessibleContext().setAccessibleDescription(getBundle("ACS_Radio1"));
        jRadioButton2.getAccessibleContext().setAccessibleDescription(getBundle("ACS_Radio2_Top"));
        proxyButton.getAccessibleContext().setAccessibleDescription(getBundle("ACS_Proxy"));
    }           
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jRadioButton1 = new javax.swing.JRadioButton();
        nextLabel = new javax.swing.JLabel();
        jRadioButton2 = new javax.swing.JRadioButton();
        rb2Label1 = new javax.swing.JLabel();
        proxyButton = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        jRadioButton1.setMnemonic(getBundle("CTL_Radio1_Mnem").charAt(0));
        jRadioButton1.setSelected(true);
        jRadioButton1.setText(getBundle("CTL_Radio1"));
        jRadioButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButton1ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.RELATIVE;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(jRadioButton1, gridBagConstraints);

        nextLabel.setText(getBundle("LAB_Init"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 36, 0, 0);
        add(nextLabel, gridBagConstraints);

        jRadioButton2.setMnemonic(getBundle("CTL_Radio2_Mnem").charAt(0));
        jRadioButton2.setText(getBundle("CTL_Radio2_Top"));
        buttonGroup=new javax.swing.ButtonGroup(); buttonGroup.add(jRadioButton1); buttonGroup.add(jRadioButton2);
        jRadioButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButton2ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(48, 0, 0, 0);
        add(jRadioButton2, gridBagConstraints);

        rb2Label1.setText(getBundle("CTL_Radio2_Bottom"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 17, 0, 0);
        add(rb2Label1, gridBagConstraints);

        proxyButton.setMnemonic(getBundle("BNT_Proxy_Mnem").charAt(0));
        proxyButton.setText(getBundle("BNT_Proxy"));
        proxyButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                proxyButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 36, 0, 0);
        add(proxyButton, gridBagConstraints);

    }//GEN-END:initComponents

    private void proxyButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_proxyButtonActionPerformed
        ProxyDialog.showDialog();
    }//GEN-LAST:event_proxyButtonActionPerformed
    
    private void jRadioButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton2ActionPerformed
         radioChange();
    }//GEN-LAST:event_jRadioButton2ActionPerformed
    
  private void jRadioButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton1ActionPerformed
         radioChange();
  }//GEN-LAST:event_jRadioButton1ActionPerformed
  
  
  private void radioChange(){  
      if(jRadioButton1.isSelected()){          
          proxyButton.setEnabled(true);
          nextLabel.setEnabled(true);
          jPanel1.setEnabled(true);
      }
      else{
          proxyButton.setEnabled(false);
          nextLabel.setEnabled(false);
          jPanel1.setEnabled(false);
      }
      validator.setValid( true );
  }
    
    /** Returns the type of wizard the user selected */
    int getWizardType( ) {
        if ( jRadioButton1.isSelected() )
            return 0;
       
        else
            return 1;
    }        
  
    private static String getBundle( String key ) {
        return NbBundle.getMessage( FirstPanel.class, key );
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JRadioButton jRadioButton1;
    private javax.swing.JRadioButton jRadioButton2;
    private javax.swing.JLabel nextLabel;
    private javax.swing.JButton proxyButton;
    private javax.swing.JLabel rb2Label1;
    // End of variables declaration//GEN-END:variables
    private javax.swing.ButtonGroup buttonGroup;
    private ServerPanel jPanel1;

}
