/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.autoupdate;


import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/** Panel and dialog for Finish wizard action.
 * @author Ales Kemr
 */
class FinishDialog extends javax.swing.JPanel {

    /** The only Finish panel instance in system */
    private static FinishDialog finishPanel;
    /** The dialog descriptor of Finish dialog */
    private static DialogDescriptor dialogDescriptor = null;
    /** The Finish dialog */
    private static java.awt.Dialog dialog = null;
    
    private static boolean restart = true;
    
    static final long serialVersionUID =-4861236822808181670L;
    /** Creates new form FinishPanel */
    public FinishDialog() {
        initComponents ();
        
        initAccessibility();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        buttonGroup1 = new javax.swing.ButtonGroup();
        commentTextArea = new javax.swing.JTextArea();
        restartRadioButton = new javax.swing.JRadioButton();
        laterRadioButton = new javax.swing.JRadioButton();

        setLayout(new java.awt.GridBagLayout());

        commentTextArea.setBackground(restartRadioButton.getBackground());
        commentTextArea.setColumns(50);
        commentTextArea.setEditable(false);
        commentTextArea.setLineWrap(true);
        commentTextArea.setRows(6);
        commentTextArea.setText(getBundle("LBL_Finish_Comment"));
        commentTextArea.setWrapStyleWord(true);
        commentTextArea.setDisabledTextColor(java.awt.Color.black);
        commentTextArea.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 12, 12);
        gridBagConstraints.weightx = 1.0;
        add(commentTextArea, gridBagConstraints);

        restartRadioButton.setMnemonic(getBundle("CTL_Finish_Restart_Mnemonic").charAt(0));
        restartRadioButton.setSelected(true);
        restartRadioButton.setText(getBundle("CTL_Finish_Restart"));
        buttonGroup1.add(restartRadioButton);
        restartRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                restartRadioButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 24, 3, 0);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(restartRadioButton, gridBagConstraints);

        laterRadioButton.setMnemonic(getBundle("CTL_Finish_Later_Mnemonic").charAt(0));
        laterRadioButton.setText(getBundle("CTL_Finish_Later"));
        buttonGroup1.add(laterRadioButton);
        laterRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                laterRadioButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 24, 0, 0);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 1.0;
        add(laterRadioButton, gridBagConstraints);

    }//GEN-END:initComponents

    private void laterRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_laterRadioButtonActionPerformed
        restart = false;
    }//GEN-LAST:event_laterRadioButtonActionPerformed

    private void restartRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_restartRadioButtonActionPerformed
        restart = true;
    }//GEN-LAST:event_restartRadioButtonActionPerformed

    private void initAccessibility(){
        getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/autoupdate/Bundle").getString("LBL_Finish_Comment"));
        getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/autoupdate/Bundle").getString("CTL_Finish_Title"));
        commentTextArea.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/autoupdate/Bundle").getString("ACSD_Comment_Text"));
        commentTextArea.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/autoupdate/Bundle").getString("ACSN_Comment_Text"));
        restartRadioButton.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/autoupdate/Bundle").getString("ACS_Finish_Restart"));
        laterRadioButton.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/autoupdate/Bundle").getString("ACS_Finish_Later"));
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JTextArea commentTextArea;
    private javax.swing.JRadioButton laterRadioButton;
    private javax.swing.JRadioButton restartRadioButton;
    // End of variables declaration//GEN-END:variables
    
    static boolean showDialog() {
        if ( dialogDescriptor == null ) {
            createDialog();
        }        
        
        return DialogDisplayer.getDefault().notify( dialogDescriptor ).equals( NotifyDescriptor.OK_OPTION );
    }
    
    static boolean isRestart() {
        return restart;
    }
    
    private static void createDialog() {
        finishPanel = new FinishDialog();
        
        dialogDescriptor = new DialogDescriptor(
                                 finishPanel,
                                 getBundle( "CTL_Finish_Title" ));
    }

    private static String getBundle( String key ) {
        return NbBundle.getMessage( FinishDialog.class, key );
    }
}
