/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.autoupdate;

import java.awt.Font;
import javax.swing.JButton;
import java.text.MessageFormat;
import java.net.URL;

import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser;
import org.openide.util.NbBundle;

/** Panel and dialog for showing External package information.
 * @author Ales Kemr
 */
class ExternalDialog extends javax.swing.JPanel {

    /** Preferred size of this dialog */
    private static final java.awt.Dimension preferredSize = new java.awt.Dimension( 450, 250 );

    /** The only External panel instance in system */
    private static ExternalDialog externalPanel;
    /** The dialog descriptor of External dialog */
    private static DialogDescriptor dialogDescriptor = null;
    /** The External dialog */
    private static java.awt.Dialog dialog = null;
    /** External dialog Accept button */
    private static JButton acceptButton;
    /** External dialog Decline button */
    private static JButton declineButton;
    
    private static String module_name;
    private static ModuleUpdate.External external;
    
    static final long serialVersionUID =-4862117522808181670L;
    /** Creates new form ExternalPanel */
    public ExternalDialog() {
        initComponents ();
        
        commentTextArea.setText(NbBundle.getMessage( ExternalDialog.class, "LBL_Ext_Comment",
                           module_name));
        nameTextField.setText( external.getName() );
        targetTextField.setText( external.getTarget_name() );
        descTextArea.setText( external.getDescription() );
        initAccessibility();
    }

    /** Overload getPreffered size to get a bit bigger dialog */
    public java.awt.Dimension getPreferredSize() {
        return preferredSize;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        commentTextArea = new javax.swing.JTextArea();
        jScrollPane1 = new javax.swing.JScrollPane();
        descTextArea = new javax.swing.JTextArea();
        nameLabel = new javax.swing.JLabel();
        nameTextField = new javax.swing.JTextField();
        targetLabel = new javax.swing.JLabel();
        descLabel = new javax.swing.JLabel();
        targetTextField = new javax.swing.JTextField();

        setLayout(new java.awt.GridBagLayout());

        setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(8, 8, 8, 8)));
        commentTextArea.setWrapStyleWord(true);
        commentTextArea.setLineWrap(true);
        commentTextArea.setEditable(false);
        commentTextArea.setBackground(nameLabel.getBackground());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(commentTextArea, gridBagConstraints);

        descTextArea.setEditable(false);
        descTextArea.setFont(new Font("Monospaced", Font.PLAIN, descTextArea.getFont().getSize() + 1));
        descTextArea.setLineWrap(true);
        descTextArea.setWrapStyleWord(true);
        jScrollPane1.setViewportView(descTextArea);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jScrollPane1, gridBagConstraints);

        nameLabel.setLabelFor(nameTextField);
        nameLabel.setText(getBundle("LBL_Ext_Name"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        add(nameLabel, gridBagConstraints);

        nameTextField.setEditable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 6, 0, 0);
        add(nameTextField, gridBagConstraints);

        targetLabel.setLabelFor(targetTextField);
        targetLabel.setText(getBundle("LBL_Ext_Target"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 24, 0, 0);
        add(targetLabel, gridBagConstraints);

        descLabel.setLabelFor(descTextArea);
        descLabel.setText(getBundle("LBL_Ext_Desc"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        add(descLabel, gridBagConstraints);

        targetTextField.setEditable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 6, 0, 0);
        add(targetTextField, gridBagConstraints);

    }//GEN-END:initComponents

    private void initAccessibility(){
        getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/autoupdate/Bundle").getString("ACSD_ExtDialog"));
        getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/autoupdate/Bundle").getString("CTL_Ext_Title"));
        commentTextArea.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/autoupdate/Bundle").getString("ACSD_Comment_Text"));
        commentTextArea.getAccessibleContext().setAccessibleName(java.util.ResourceBundle.getBundle("org/netbeans/modules/autoupdate/Bundle").getString("ACSN_Comment_Text"));        
        descTextArea.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/autoupdate/Bundle").getString("ACSD_Ext_Desc"));        
        nameLabel.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/autoupdate/Bundle").getString("ACS_Ext_Name_mnc").charAt(0));
        nameTextField.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/autoupdate/Bundle").getString("ACSD_Ext_Name"));
        targetLabel.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/autoupdate/Bundle").getString("ACS_Ext_Target_mnc").charAt(0));
        descLabel.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("org/netbeans/modules/autoupdate/Bundle").getString("ACS_Ext_Desc_mnc").charAt(0));
        targetTextField.getAccessibleContext().setAccessibleDescription(java.util.ResourceBundle.getBundle("org/netbeans/modules/autoupdate/Bundle").getString("ACSD_Ext_Target"));
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextArea commentTextArea;
    private javax.swing.JLabel descLabel;
    private javax.swing.JTextArea descTextArea;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JLabel nameLabel;
    private javax.swing.JTextField nameTextField;
    private javax.swing.JLabel targetLabel;
    private javax.swing.JTextField targetTextField;
    // End of variables declaration//GEN-END:variables
    
    static void showExternal( String name, ModuleUpdate.External ext_upd ) {
        module_name = name;
        external = ext_upd;

        createDialog();
        
        dialog.show();
    }
    
    private static void createDialog() {
        externalPanel = new ExternalDialog();

        acceptButton = new JButton( getBundle( "BTN_Ext_OK" ) );
        acceptButton.getAccessibleContext().setAccessibleDescription(getBundle( "ACSD_Ext_OK" ));
        acceptButton.setMnemonic(getBundle( "ACS_Ext_OK_mnc" ).charAt(0));
        declineButton = new JButton( getBundle( "BTN_Ext_Cancel" ) );
        declineButton.getAccessibleContext().setAccessibleDescription(getBundle( "ACSD_Ext_Cancel" ));
        declineButton.setMnemonic(getBundle( "ACS_Ext_Cancel_mnc" ).charAt(0));

        dialogDescriptor = new DialogDescriptor(
                               externalPanel,
                               getBundle( "CTL_Ext_Title" ),
                               true,                                                 // Modal
                               new Object[] { acceptButton, declineButton },         // Option list
                               acceptButton,                                         // Default
                               DialogDescriptor.BOTTOM_ALIGN,                        // Align
                               null,                                                 // Help
                               new java.awt.event.ActionListener() {
                                   public void actionPerformed( java.awt.event.ActionEvent evt ) {
                                       if ( evt.getSource() == acceptButton )
                                           try {
                                               HtmlBrowser.URLDisplayer.getDefault().showURL( new URL ( external.getStart_url() ));
                                           }
                                           catch ( java.net.MalformedURLException e ) {
                                               ErrorManager.getDefault().notify( e );
                                           }

                                       dialog.setVisible( false );
                                   }
                               });

        dialog = DialogDisplayer.getDefault().createDialog( dialogDescriptor );
    }

    private static String getBundle( String key ) {
        return NbBundle.getMessage( ExternalDialog.class, key );
    }
}
