/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.autoupdate;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/**
 *
 * @author  Jiri Rechtacek
 */
public class ConnectingErrorDialog extends javax.swing.JPanel {

    /** Type of the dialog */
    private static int type;
    private static String serverMessage;
    
    ConnectingErrorDialog () {
        this (false, null);
    }
    
    /**
     * Creates new form ConnectingErrorDialog 
     */
    private ConnectingErrorDialog (boolean hasInner, JButton okButton) {
        if (hasInner) {
            assert okButton != null : "okButton must exist if the dialog hasInner";
            initComponents ();
            okButton.addActionListener (new ActionListener () {
                public void actionPerformed (ActionEvent evt) {
                    ProxyDialog proxyPanel = (ProxyDialog)jPanel1;
                            
                    Autoupdater.setProxyConfiguration (
                                    proxyPanel.getProxyType (),
                                    proxyPanel.getUserProxyHost (),
                                    proxyPanel.getUserProxyPort ());
                    
                    AutoChecker.doCheck ();
                }
            });
        } else {
            initComponentsWithoutInner ();
        }
    }
    
    private void initComponentsWithoutInner () {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        jTextArea1 = new javax.swing.JTextArea();

        setLayout(new java.awt.GridBagLayout());

        setName(getDialogTitle (type));
        getAccessibleContext().setAccessibleName(getDialogTitle (type));
        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ConnectingErrorDialog.class, "ACSD_ConnError"));
        // don't use deriveFont() - see #49973 for details
        jLabel1.setFont(ResultsPanel.doDeriveFont(jLabel1.getFont(), Font.BOLD));
        jLabel1.setLabelFor(jTextArea1);
        jLabel1.setText (getMessageLabel (type));
        jLabel1.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 4, 0);
        jLabel1.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ConnectingErrorDialog.class, "ACD_ConnectingErrorDialog_jLabel1"));
        add(jLabel1, gridBagConstraints);

        jTextArea1.setBackground(jLabel1.getBackground());
        jTextArea1.setEditable(false);
        jTextArea1.setLineWrap(true);
        jTextArea1.setText (getMessageText (type, serverMessage));
        jTextArea1.setWrapStyleWord(true);
        jTextArea1.setRows (4);
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 6, 0);
        add(jTextArea1, gridBagConstraints);
        
        jTextArea1.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(ConnectingErrorDialog.class, "ACN_ConnectingErrorDialog_jTextArea1"));
        jTextArea1.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ConnectingErrorDialog.class, "ACD_ConnectingErrorDialog_jTextArea1"));
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        jTextArea1 = new javax.swing.JTextArea();
        jPanel1 = new ProxyDialog ();

        setLayout(new java.awt.GridBagLayout());

        setName(getDialogTitle (type));
        getAccessibleContext().setAccessibleName(getDialogTitle (type));
        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ConnectingErrorDialog.class, "ACSD_ConnError"));
        jLabel1.setLabelFor(jTextArea1);
        jLabel1.setText(org.openide.util.NbBundle.getMessage(ConnectingErrorDialog.class, "CTL_NoNetwork_titleLabel"));
        jLabel1.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 8, 8, 0);
        add(jLabel1, gridBagConstraints);
        jLabel1.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ConnectingErrorDialog.class, "ACD_ConnectingErrorDialog_jLabel1"));

        jTextArea1.setBackground(jLabel1.getBackground());
        jTextArea1.setEditable(false);
        jTextArea1.setLineWrap(true);
        jTextArea1.setText(org.openide.util.NbBundle.getMessage(ConnectingErrorDialog.class, "CTL_NoNetwork_textLabel"));
        jTextArea1.setWrapStyleWord(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 8, 6, 0);
        add(jTextArea1, gridBagConstraints);
        jTextArea1.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(ConnectingErrorDialog.class, "ACN_NoNetwork_textLabel"));
        jTextArea1.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(ConnectingErrorDialog.class, "ACD_NoNetwork_textLabel"));

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Proxy Settings"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(jPanel1, gridBagConstraints);

    }//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JTextArea jTextArea1;
    // End of variables declaration//GEN-END:variables
    
    static private String getDialogTitle (int errorType) {
        switch (errorType) {
            case Updates.NO_AVAILABLE_MODULES:
                return getBundle ("CTL_Warning");
            case Updates.NO_SERVER_ERROR:
                return getBundle ("CTL_Warning");
            default:
                return getBundle ("CTL_Error");
        }
    }
    
    static private String getMessageLabel (int errorType) {
        switch (errorType) {
            case Updates.NO_AVAILABLE_MODULES:
                return getBundle ("CTL_NoAvailableModules_titleLabel");
            case Updates.NO_SERVER_ERROR:
                return getBundle ("CTL_NoServer_titleLabel");
            case Updates.NO_NETWORK:
                return getBundle ("CTL_NoNetwork_titleLabel");
            case Updates.AUTH_ERROR:
                return getBundle ("CTL_Invalid_titleLabel");
            case Updates.PARSE_ERROR:
                return getBundle ("CTL_ParseError_titleLabel");
            default:
                assert false : "Unknown error type " + errorType;
        }
        return null;
    }

    static private String getMessageText (int errorType, String serverMessage) {
        switch (errorType) {
            case Updates.NO_AVAILABLE_MODULES:
                if (serverMessage == null) {
                    serverMessage = getBundle ("CTL_DefaultServer");
                }
                return NbBundle.getMessage (ConnectingErrorDialog.class, "CTL_NoAvailableModules_textLabel", serverMessage);
            case Updates.NO_SERVER_ERROR:
                return getBundle ("CTL_NoServer_textLabel");
            case Updates.NO_NETWORK:
                if (serverMessage != null) {
                    return serverMessage;
                } else {
                    return getBundle ("CTL_NoNetwork_textLabel");
                }
            case Updates.AUTH_ERROR:
                return getBundle ("CTL_Invalid_textLabel");
            case Updates.PARSE_ERROR:
                return getBundle ("CTL_ParseError_textLabel");
            default:
                assert false : "Unknown error type " + errorType;
        }
        return null;
    }

    private static DialogDescriptor createDialogDescriptor (boolean fromAutoCheck) {
        DialogDescriptor dd;
        
        if (Updates.NO_NETWORK == type) {
            if (fromAutoCheck) {
                final JButton continueButton = new JButton ();
                continueButton.setEnabled (true);
                org.openide.awt.Mnemonics.setLocalizedText (continueButton, getBundle( "CTL_Error_Continue" ));
                continueButton.getAccessibleContext().setAccessibleDescription(getBundle( "ACSD_Error_Continue" ) );

                final JButton cancelButton = new JButton(getBundle( "CTL_Error_Cancel" ) );
                cancelButton.getAccessibleContext().setAccessibleDescription(getBundle( "ACSD_Error_Cancel" ) );

                dd = new DialogDescriptor(
                     new ConnectingErrorDialog (true, continueButton),
                     getDialogTitle (type),
                     true,                                  // Modal
                     new Object [] {continueButton, cancelButton}, // Option list
                     continueButton,                         // Default
                     DialogDescriptor.DEFAULT_ALIGN,        // Align
                     null, //new HelpCtx ( ConnectingErrorDialog.class ), // Help
                     null
                 );
                dd.setMessageType (NotifyDescriptor.ERROR_MESSAGE);
                dd.setClosingOptions (new Object [] {continueButton, cancelButton});
            } else {
                // bugfix #40917, mnemonic on default OK button is useless
                final JButton okButton = new JButton(getBundle( "CTL_Error_OK" ) );
                okButton.getAccessibleContext().setAccessibleDescription(getBundle( "ACSD_Error_OK" ) );

                // default options
                dd = new DialogDescriptor (
                     new ConnectingErrorDialog (false, null),
                     getDialogTitle (type),
                     true,                                  // Modal
                     new Object [] {okButton}, // Option list
                     okButton,                         // Default
                     DialogDescriptor.DEFAULT_ALIGN,        // Align
                     null, //new HelpCtx ( ConnectingErrorDialog.class ), // Help
                     null
                 );
                 dd.setMessageType (NotifyDescriptor.ERROR_MESSAGE);
            }
        } else {
                // bugfix #40917, mnemonic on default OK button is useless
                final JButton okButton = new JButton(getBundle( "CTL_Error_OK" ) );
                okButton.getAccessibleContext().setAccessibleDescription(getBundle( "ACSD_Error_OK" ) );

                // default options
                dd = new DialogDescriptor (
                     new ConnectingErrorDialog (false, null),
                     getDialogTitle (type),
                     true,                                  // Modal
                     new Object [] {okButton}, // Option list
                     okButton,                         // Default
                     DialogDescriptor.DEFAULT_ALIGN,        // Align
                     null, //new HelpCtx ( ConnectingErrorDialog.class ), // Help
                     null
                 );
                 dd.setMessageType (NotifyDescriptor.WARNING_MESSAGE);
        }

        return dd;
    }
    
    static void showDialog(int type, String serverMessage) {
        showDialog (type, serverMessage, false);
    }
    
    static void showDialog(int type, String serverMessage, boolean fromAutoCheck) {
        ConnectingErrorDialog.type = type;
        ConnectingErrorDialog.serverMessage = serverMessage;
        DialogDescriptor dd = createDialogDescriptor (fromAutoCheck);
        java.awt.Dialog dialog = DialogDisplayer.getDefault().createDialog( dd );
        //dialog.setResizable (false);
        dialog.setVisible (true);
        dialog.dispose();
    }
    
    private static String getBundle( String key ) {
        return NbBundle.getMessage( ConnectingErrorDialog.class, key );
    }

}
