/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.autoupdate;

import java.awt.Font;
import java.util.Collection;
import javax.swing.*;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

/**
 *
 * @author 
 */
class CertificateDialog extends javax.swing.JPanel {

    static final int CLOSE = 0;
    static final int ACCEPT = 1;
    static final int ALWAYS_ACCEPT = 2;
    static final int NOT_ALWAYS_ACCEPT = 3;
    static final int REJECT = 4;
    /** Result of the dialog */
    private static int result = CLOSE;

    static final int SIGNED_MODULE = 0;
    static final int TRUSTED_MODULE = 1;
    /** Type of the dialog */
    private static int type;

    /** Creates new form CertificateDialog */
    public CertificateDialog(Collection certs) {
        initComponents();
        certificateTextArea.setText( SignVerifier.formatCerts( certs ) );
        certificateTextArea.setCaretPosition(0);
//        setPreferredSize(new java.awt.Dimension(350,220));

        getAccessibleContext().setAccessibleName(getBundle("CTL_Certificate_Title"));
        getAccessibleContext().setAccessibleDescription(aboutTextArea.getText());
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        aboutTextArea = new javax.swing.JTextArea();
        jScrollPane1 = new javax.swing.JScrollPane();
        certificateTextArea = new javax.swing.JTextArea();

        setLayout(new java.awt.GridBagLayout());

        setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(12, 12, 11, 11)));
        aboutTextArea.setBackground(javax.swing.UIManager.getDefaults().getColor("TextField.inactiveBackground"));
        aboutTextArea.setFont(new Font("Dialog", Font.PLAIN, aboutTextArea.getFont().getSize()));
        aboutTextArea.setLineWrap(true);
        aboutTextArea.setText(NbBundle.getBundle(CertificateDialog.class).getString(type == SIGNED_MODULE ? "CTL_Certificate_Signed_About" : "CTL_Certificate_Trusted_About"));
        aboutTextArea.setWrapStyleWord(true);
        aboutTextArea.setDisabledTextColor(javax.swing.UIManager.getDefaults().getColor("TextField.foreground"));
        aboutTextArea.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(aboutTextArea, gridBagConstraints);

        certificateTextArea.setDisabledTextColor(javax.swing.UIManager.getDefaults().getColor("TextField.foreground"));
        certificateTextArea.setEnabled(false);
        jScrollPane1.setViewportView(certificateTextArea);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 0);
        add(jScrollPane1, gridBagConstraints);

    }//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextArea aboutTextArea;
    private javax.swing.JTextArea certificateTextArea;
    private javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables
    
    private static DialogDescriptor createDialog(Collection certs) {

        Object[] buttons;
        final JButton closeButton = new JButton(getBundle( "CTL_Certificate_Close" ) );
        final JButton acceptButton = new JButton(getBundle( "CTL_Certificate_Accept" ) );
        final JButton alwaysButton = new JButton(getBundle( "CTL_Certificate_AlwaysAccept" ) );
        final JButton notalwaysButton = new JButton(getBundle( "CTL_Certificate_NotAlwaysAccept" ) );
        final JButton rejectButton = new JButton(getBundle( "CTL_Certificate_Reject" ) );

        closeButton.getAccessibleContext().setAccessibleDescription(getBundle("ACS_Certificate_Close"));
        acceptButton.getAccessibleContext().setAccessibleDescription(getBundle("ACS_Certificate_Accept"));
        alwaysButton.getAccessibleContext().setAccessibleDescription(getBundle("ACS_Certificate_AlwaysAccept"));
        notalwaysButton.getAccessibleContext().setAccessibleDescription(getBundle("ACS_Certificate_NotAlwaysAccept"));
        rejectButton.getAccessibleContext().setAccessibleDescription(getBundle("ACS_Certificate_Reject"));
        //mnemonics
        closeButton.setMnemonic(getBundle("ACS_Certificate_Close_mnc").charAt(0));
        acceptButton.setMnemonic(getBundle("ACS_Certificate_Accept_mnc").charAt(0));
        alwaysButton.setMnemonic(getBundle("ACS_Certificate_AlwaysAccept_mnc").charAt(0));
        notalwaysButton.setMnemonic(getBundle("ACS_Certificate_NotAlwaysAccept_mnc").charAt(0));
        rejectButton.setMnemonic(getBundle("ACS_Certificate_Reject_mnc").charAt(0));

        if (type == SIGNED_MODULE)
            buttons = new Object [] {
                acceptButton,
                alwaysButton,
                rejectButton,
                closeButton
            };
        else
            buttons = new Object [] {
                notalwaysButton,
                closeButton
            };
        
        DialogDescriptor dd;
        dd = new DialogDescriptor(
                 new CertificateDialog(certs),
                 getBundle( "CTL_Certificate_Title" ),
                 true,                                  // Modal
                 buttons,                               // Option list
                 closeButton,                           // Default
                 DialogDescriptor.DEFAULT_ALIGN,        // Align
                 null, //new HelpCtx (CertificateDialog.class), // Help
                 new java.awt.event.ActionListener() {
                     public void actionPerformed( java.awt.event.ActionEvent evt ) {
                         if ( evt.getSource() == acceptButton )
                             result = ACCEPT;
                         else if ( evt.getSource() == alwaysButton )
                             result = ALWAYS_ACCEPT;
                         else if ( evt.getSource() == notalwaysButton )
                             result = NOT_ALWAYS_ACCEPT;
                         else if ( evt.getSource() == rejectButton )
                             result = REJECT;
                         else if ( evt.getSource() == closeButton )
                             result = CLOSE;                         
                     }
                 });

        dd.setClosingOptions( null );

        return dd;
    }
    
    static int showDialog(Collection certs, int type) {
        if (type == SignVerifier.TRUSTED)
            CertificateDialog.type = TRUSTED_MODULE;
        else
            CertificateDialog.type = SIGNED_MODULE;
        DialogDescriptor dd = createDialog(certs);
        java.awt.Dialog dialog = DialogDisplayer.getDefault().createDialog( dd );
        dialog.show();
        dialog.dispose();
        
        return result;
    }
    
    private static String getBundle( String key ) {
        return NbBundle.getMessage( CertificateDialog.class, key );
    }
}
